/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.renderers.CSVWriter;
import net.sourceforge.pmd.renderers.ColumnDescriptor;
import net.sourceforge.pmd.util.StringUtil;

public class CSVRenderer
extends AbstractIncrementingRenderer {
    private String separator;
    private String cr;
    private CSVWriter<RuleViolation> csvWriter;
    private static final String DEFAULT_SEPARATOR = ",";
    private static final Map<String, BooleanProperty> PROPERTY_DESCRIPTORS_BY_ID = new HashMap<String, BooleanProperty>();
    public static final String NAME = "csv";
    private static final ColumnDescriptor<RuleViolation>[] ALL_COLUMNS = new ColumnDescriptor[]{new ColumnDescriptor<RuleViolation>("problem", "Problem", new ColumnDescriptor.Accessor<RuleViolation>(){

        @Override
        public String get(int idx, RuleViolation rv, String cr) {
            return Integer.toString(idx);
        }
    }), new ColumnDescriptor<RuleViolation>("package", "Package", new ColumnDescriptor.Accessor<RuleViolation>(){

        @Override
        public String get(int idx, RuleViolation rv, String cr) {
            return rv.getPackageName();
        }
    }), new ColumnDescriptor<RuleViolation>("file", "File", new ColumnDescriptor.Accessor<RuleViolation>(){

        @Override
        public String get(int idx, RuleViolation rv, String cr) {
            return rv.getFilename();
        }
    }), new ColumnDescriptor<RuleViolation>("priority", "Priority", new ColumnDescriptor.Accessor<RuleViolation>(){

        @Override
        public String get(int idx, RuleViolation rv, String cr) {
            return Integer.toString(rv.getRule().getPriority().getPriority());
        }
    }), new ColumnDescriptor<RuleViolation>("line", "Line", new ColumnDescriptor.Accessor<RuleViolation>(){

        @Override
        public String get(int idx, RuleViolation rv, String cr) {
            return Integer.toString(rv.getBeginLine());
        }
    }), new ColumnDescriptor<RuleViolation>("desc", "Description", new ColumnDescriptor.Accessor<RuleViolation>(){

        @Override
        public String get(int idx, RuleViolation rv, String cr) {
            return StringUtil.replaceString(rv.getDescription(), '\"', "'");
        }
    }), new ColumnDescriptor<RuleViolation>("ruleSet", "Rule set", new ColumnDescriptor.Accessor<RuleViolation>(){

        @Override
        public String get(int idx, RuleViolation rv, String cr) {
            return rv.getRule().getRuleSetName();
        }
    }), new ColumnDescriptor<RuleViolation>("rule", "Rule", new ColumnDescriptor.Accessor<RuleViolation>(){

        @Override
        public String get(int idx, RuleViolation rv, String cr) {
            return rv.getRule().getName();
        }
    })};

    public CSVRenderer(ColumnDescriptor<RuleViolation>[] columns, String theSeparator, String theCR) {
        super(NAME, "Comma-separated values tabular format.");
        this.separator = theSeparator;
        this.cr = theCR;
        for (ColumnDescriptor<RuleViolation> desc : columns) {
            this.definePropertyDescriptor(CSVRenderer.booleanPropertyFor(desc.id, desc.title));
        }
    }

    public CSVRenderer() {
        this(ALL_COLUMNS, DEFAULT_SEPARATOR, PMD.EOL);
    }

    private static BooleanProperty booleanPropertyFor(String id, String label) {
        BooleanProperty prop = PROPERTY_DESCRIPTORS_BY_ID.get(id);
        if (prop != null) {
            return prop;
        }
        prop = new BooleanProperty(id, "Include " + label + " column", true, 1.0f);
        PROPERTY_DESCRIPTORS_BY_ID.put(id, prop);
        return prop;
    }

    private List<ColumnDescriptor<RuleViolation>> activeColumns() {
        ArrayList<ColumnDescriptor<RuleViolation>> actives = new ArrayList<ColumnDescriptor<RuleViolation>>();
        for (ColumnDescriptor<RuleViolation> desc : ALL_COLUMNS) {
            BooleanProperty prop = CSVRenderer.booleanPropertyFor(desc.id, null);
            if (!this.getProperty(prop).booleanValue()) continue;
            actives.add(desc);
        }
        return actives;
    }

    private CSVWriter<RuleViolation> csvWriter() {
        if (this.csvWriter != null) {
            return this.csvWriter;
        }
        this.csvWriter = new CSVWriter(this.activeColumns(), this.separator, this.cr);
        return this.csvWriter;
    }

    @Override
    public void start() throws IOException {
        this.csvWriter().writeTitles(this.getWriter());
    }

    @Override
    public String defaultFileExtension() {
        return NAME;
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        this.csvWriter().writeData(this.getWriter(), violations);
    }

    @Override
    public String dysfunctionReason() {
        return this.activeColumns().isEmpty() ? "No columns selected" : null;
    }
}

