/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import net.sourceforge.pmd.RuleSetNotFoundException;

public final class ResourceLoader {
    public static final int TIMEOUT;

    private ResourceLoader() {
    }

    public static InputStream loadResourceAsStream(String name) throws RuleSetNotFoundException {
        InputStream stream = ResourceLoader.loadResourceAsStream(name, ResourceLoader.class.getClassLoader());
        if (stream == null) {
            throw new RuleSetNotFoundException("Can't find resource " + name + ". Make sure the resource is a valid file or URL or is on the CLASSPATH");
        }
        return stream;
    }

    public static InputStream loadResourceAsStream(String name, ClassLoader loader) throws RuleSetNotFoundException {
        File file = new File(name);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
            }
        } else {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(name).openConnection();
                connection.setConnectTimeout(TIMEOUT);
                connection.setReadTimeout(TIMEOUT);
                return connection.getInputStream();
            }
            catch (Exception e) {
                try {
                    URL resource = loader.getResource(name);
                    if (resource == null) {
                        return null;
                    }
                    URLConnection connection = resource.openConnection();
                    connection.setUseCaches(false);
                    InputStream inputStream = connection.getInputStream();
                    return inputStream;
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        throw new RuleSetNotFoundException("Can't find resource " + name + ". Make sure the resource is a valid file or URL or is on the CLASSPATH");
    }

    static {
        int timeoutProperty = 5000;
        try {
            timeoutProperty = Integer.parseInt(System.getProperty("net.sourceforge.pmd.http.timeout", "5000"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        TIMEOUT = timeoutProperty;
    }
}

