/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.util.ResourceLoader;
import org.apache.commons.lang3.StringUtils;

public class RuleSetReferenceId {
    private final boolean external;
    private final String ruleSetFileName;
    private final boolean allRules;
    private final String ruleName;
    private final RuleSetReferenceId externalRuleSetReferenceId;

    public RuleSetReferenceId(String id) {
        this(id, null);
    }

    public RuleSetReferenceId(String id, RuleSetReferenceId externalRuleSetReferenceId) {
        if (externalRuleSetReferenceId != null && !externalRuleSetReferenceId.isExternal()) {
            throw new IllegalArgumentException("Cannot pair with non-external <" + externalRuleSetReferenceId + ">.");
        }
        if (id != null && id.indexOf(44) >= 0) {
            throw new IllegalArgumentException("A single RuleSetReferenceId cannot contain ',' (comma) characters: " + id);
        }
        if (RuleSetReferenceId.isValidUrl(id)) {
            this.external = true;
            this.ruleSetFileName = StringUtils.strip((String)id);
            this.allRules = true;
            this.ruleName = null;
        } else if (RuleSetReferenceId.isFullRuleSetName(id)) {
            this.external = true;
            this.ruleSetFileName = id;
            this.allRules = true;
            this.ruleName = null;
        } else {
            String tempRuleSetFileName;
            String tempRuleName = this.getRuleName(id);
            String string = tempRuleSetFileName = tempRuleName != null && id != null ? id.substring(0, id.length() - tempRuleName.length() - 1) : id;
            if (RuleSetReferenceId.isValidUrl(tempRuleSetFileName)) {
                this.external = true;
                this.ruleSetFileName = StringUtils.strip((String)tempRuleSetFileName);
                this.ruleName = StringUtils.strip((String)tempRuleName);
                this.allRules = tempRuleName == null;
            } else if (RuleSetReferenceId.isHttpUrl(id)) {
                this.external = true;
                this.ruleSetFileName = StringUtils.strip((String)id);
                this.allRules = true;
                this.ruleName = null;
            } else if (RuleSetReferenceId.isFullRuleSetName(tempRuleSetFileName)) {
                this.external = true;
                this.ruleSetFileName = tempRuleSetFileName;
                this.ruleName = tempRuleName;
                this.allRules = tempRuleName == null;
            } else {
                String builtinRuleSet = this.resolveBuiltInRuleset(tempRuleSetFileName);
                if (this.checkRulesetExists(builtinRuleSet)) {
                    this.external = true;
                    this.ruleSetFileName = builtinRuleSet;
                    this.ruleName = tempRuleName;
                    this.allRules = tempRuleName == null;
                } else if (tempRuleSetFileName == null || tempRuleSetFileName.contains(File.separator)) {
                    this.external = true;
                    this.ruleSetFileName = id;
                    this.ruleName = null;
                    this.allRules = true;
                } else {
                    this.external = externalRuleSetReferenceId != null && externalRuleSetReferenceId.isExternal();
                    this.ruleSetFileName = externalRuleSetReferenceId != null ? externalRuleSetReferenceId.getRuleSetFileName() : null;
                    this.ruleName = id;
                    this.allRules = false;
                }
            }
        }
        if (this.external && this.ruleName != null && !this.ruleName.equals(id) && externalRuleSetReferenceId != null) {
            throw new IllegalArgumentException("Cannot pair external <" + this + "> with external <" + externalRuleSetReferenceId + ">.");
        }
        this.externalRuleSetReferenceId = externalRuleSetReferenceId;
    }

    private boolean checkRulesetExists(String name) {
        boolean resourceFound = false;
        if (name != null) {
            try (InputStream resource = new ResourceLoader().loadClassPathResourceAsStreamOrThrow(name);){
                resourceFound = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resourceFound;
    }

    private String resolveBuiltInRuleset(String name) {
        String result = null;
        if (name != null) {
            int index = name.indexOf(45);
            result = index >= 0 ? "rulesets/" + name.substring(0, index) + '/' + name.substring(index + 1) + ".xml" : (name.matches("[0-9]+.*") ? "rulesets/releases/" + name + ".xml" : name);
        }
        return result;
    }

    private String getRuleName(String rulesetName) {
        int separatorIndex;
        String result = null;
        if (rulesetName != null && (separatorIndex = Math.max(rulesetName.lastIndexOf(47), rulesetName.lastIndexOf(92))) >= 0 && separatorIndex != rulesetName.length() - 1) {
            result = rulesetName.substring(separatorIndex + 1);
        }
        return result;
    }

    private static boolean isHttpUrl(String name) {
        String stripped = StringUtils.strip((String)name);
        if (stripped == null) {
            return false;
        }
        return stripped.startsWith("http://") || stripped.startsWith("https://");
    }

    private static boolean isValidUrl(String name) {
        if (RuleSetReferenceId.isHttpUrl(name)) {
            String url = StringUtils.strip((String)name);
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("HEAD");
                connection.setConnectTimeout(ResourceLoader.TIMEOUT);
                connection.setReadTimeout(ResourceLoader.TIMEOUT);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private static boolean isFullRuleSetName(String name) {
        return name != null && name.endsWith(".xml");
    }

    public static List<RuleSetReferenceId> parse(String referenceString) {
        ArrayList<RuleSetReferenceId> references = new ArrayList<RuleSetReferenceId>();
        if (referenceString != null && referenceString.trim().length() > 0) {
            if (referenceString.indexOf(44) == -1) {
                references.add(new RuleSetReferenceId(referenceString));
            } else {
                for (String name : referenceString.split(",")) {
                    references.add(new RuleSetReferenceId(name.trim()));
                }
            }
        }
        return references;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isAllRules() {
        return this.allRules;
    }

    public String getRuleSetFileName() {
        return this.ruleSetFileName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public InputStream getInputStream(ResourceLoader rl) throws RuleSetNotFoundException {
        if (this.externalRuleSetReferenceId == null) {
            InputStream in;
            InputStream inputStream = in = StringUtils.isBlank((CharSequence)this.ruleSetFileName) ? null : rl.loadResourceAsStream(this.ruleSetFileName);
            if (in == null) {
                throw new RuleSetNotFoundException("Can't find resource '" + this.ruleSetFileName + "' for rule '" + this.ruleName + "'.  Make sure the resource is a valid file or URL and is on the CLASSPATH. Here's the current classpath: " + System.getProperty("java.class.path"));
            }
            return in;
        }
        return this.externalRuleSetReferenceId.getInputStream(rl);
    }

    public String toString() {
        if (this.ruleSetFileName != null) {
            if (this.allRules) {
                return this.ruleSetFileName;
            }
            return this.ruleSetFileName + '/' + this.ruleName;
        }
        if (this.allRules) {
            return "anonymous all Rule";
        }
        return this.ruleName;
    }
}

