/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompoundIterator<T>
implements Iterator<T> {
    private final Iterator<T>[] iterators;
    private int index;

    public CompoundIterator(Iterator<T> ... iterators) {
        this.iterators = iterators;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.getNextIterator() != null;
    }

    @Override
    public T next() {
        Iterator<T> iterator = this.getNextIterator();
        if (iterator != null) {
            return iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        Iterator<T> iterator = this.getNextIterator();
        if (iterator == null) {
            throw new IllegalStateException();
        }
        iterator.remove();
    }

    private Iterator<T> getNextIterator() {
        while (this.index < this.iterators.length) {
            if (this.iterators[this.index].hasNext()) {
                return this.iterators[this.index];
            }
            ++this.index;
        }
        return null;
    }
}

