/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.viewer.gui.menu.ASTNodePopupMenu;
import net.sourceforge.pmd.util.viewer.model.ASTModel;
import net.sourceforge.pmd.util.viewer.model.ViewerModel;
import net.sourceforge.pmd.util.viewer.model.ViewerModelEvent;
import net.sourceforge.pmd.util.viewer.model.ViewerModelListener;
import net.sourceforge.pmd.util.viewer.util.NLS;

@Deprecated
public class ASTPanel
extends JPanel
implements ViewerModelListener,
TreeSelectionListener {
    private ViewerModel model;
    private JTree tree;

    public ASTPanel(ViewerModel model) {
        this.model = model;
        this.init();
    }

    private void init() {
        this.model.addViewerModelListener(this);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NLS.nls("AST.PANEL.TITLE")));
        this.setLayout(new BorderLayout());
        this.tree = new JTree((TreeNode)null);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreePath path = ASTPanel.this.tree.getClosestPathForLocation(e.getX(), e.getY());
                    ASTPanel.this.tree.setSelectionPath(path);
                    ASTNodePopupMenu menu = new ASTNodePopupMenu(ASTPanel.this.model, (Node)path.getLastPathComponent());
                    menu.show(ASTPanel.this.tree, e.getX(), e.getY());
                }
            }
        });
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    @Override
    public void viewerModelChanged(ViewerModelEvent e) {
        switch (e.getReason()) {
            case 1: {
                this.tree.setModel(new ASTModel(this.model.getRootNode()));
                break;
            }
            case 2: {
                if (e.getSource() == this) break;
                ArrayList<Node> list = new ArrayList<Node>();
                for (Node n = (Node)e.getParameter(); n != null; n = n.jjtGetParent()) {
                    list.add(n);
                }
                Collections.reverse(list);
                TreePath path = new TreePath(list.toArray());
                this.tree.setSelectionPath(path);
                this.tree.scrollPathToVisible(path);
                break;
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.model.selectNode((Node)e.getNewLeadSelectionPath().getLastPathComponent(), this);
    }
}

