/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;

public class TextColorRenderer
extends AbstractAccumulatingRenderer {
    public static final String NAME = "textcolor";
    public static final StringProperty COLOR = new StringProperty("color", "Enables colors with anything other than 'false' or '0'.", "yes", 0.0f);
    private static final String SYSTEM_PROPERTY_PMD_COLOR = "pmd.color";
    private String pwd;
    private String yellowBold = "";
    private String whiteBold = "";
    private String redBold = "";
    private String red = "";
    private String cyan = "";
    private String green = "";
    private String colorReset = "";

    public TextColorRenderer() {
        super(NAME, "Text format, with color support (requires ANSI console support, e.g. xterm, rxvt, etc.).");
        this.definePropertyDescriptor(COLOR);
    }

    @Override
    public String defaultFileExtension() {
        return "txt";
    }

    private void initializeColorsIfSupported() {
        if (this.isPropertyEnabled(this.getProperty(COLOR)) || this.isPropertyEnabled(System.getProperty(SYSTEM_PROPERTY_PMD_COLOR))) {
            this.yellowBold = "\u001b[1;33m";
            this.whiteBold = "\u001b[1;37m";
            this.redBold = "\u001b[1;31m";
            this.red = "\u001b[0;31m";
            this.green = "\u001b[0;32m";
            this.cyan = "\u001b[0;36m";
            this.colorReset = "\u001b[0m";
        }
    }

    private boolean isPropertyEnabled(String property) {
        return property != null && !"0".equals(property) && !"false".equalsIgnoreCase(property);
    }

    @Override
    public void end() throws IOException {
        StringBuilder buf = new StringBuilder(500);
        buf.append(PMD.EOL);
        this.initializeColorsIfSupported();
        String lastFile = null;
        int numberOfErrors = 0;
        int numberOfWarnings = 0;
        Iterator<RuleViolation> i = this.report.iterator();
        while (i.hasNext()) {
            buf.setLength(0);
            ++numberOfWarnings;
            RuleViolation rv = i.next();
            String string = this.determineFileName(rv.getFilename());
            if (!string.equals(lastFile)) {
                lastFile = string;
                buf.append(this.yellowBold + "*" + this.colorReset + " file: " + this.whiteBold + this.getRelativePath(lastFile) + this.colorReset + PMD.EOL);
            }
            buf.append(this.green + "    src:  " + this.cyan + lastFile.substring(lastFile.lastIndexOf(File.separator) + 1) + this.colorReset + ":" + this.cyan + rv.getBeginLine() + (rv.getEndLine() == -1 ? "" : ":" + rv.getEndLine()) + this.colorReset + PMD.EOL);
            buf.append(this.green + "    rule: " + this.colorReset + rv.getRule().getName() + PMD.EOL);
            buf.append(this.green + "    msg:  " + this.colorReset + rv.getDescription() + PMD.EOL);
            buf.append(this.green + "    code: " + this.colorReset + this.getLine(lastFile, rv.getBeginLine()) + PMD.EOL + PMD.EOL);
            this.writer.write(buf.toString());
        }
        this.writer.write(PMD.EOL + PMD.EOL);
        this.writer.write("Summary:" + PMD.EOL + PMD.EOL);
        Map<String, Integer> summary = this.report.getCountSummary();
        for (Map.Entry entry : summary.entrySet()) {
            buf.setLength(0);
            String key = (String)entry.getKey();
            buf.append(key).append(" : ").append(entry.getValue()).append(PMD.EOL);
            this.writer.write(buf.toString());
        }
        Iterator<Report.ProcessingError> i2 = this.report.errors();
        while (i2.hasNext()) {
            buf.setLength(0);
            ++numberOfErrors;
            Report.ProcessingError processingError = i2.next();
            String nextFile = this.determineFileName(processingError.getFile());
            if (!nextFile.equals(lastFile)) {
                lastFile = nextFile;
                buf.append(this.redBold + "*" + this.colorReset + " file: " + this.whiteBold + this.getRelativePath(lastFile) + this.colorReset + PMD.EOL);
            }
            buf.append(this.green + "    err:  " + this.cyan + processingError.getMsg() + this.colorReset + PMD.EOL).append(this.red).append(processingError.getDetail()).append(this.colorReset).append(PMD.EOL).append(PMD.EOL);
            this.writer.write(buf.toString());
        }
        Iterator<Report.ConfigurationError> i3 = this.report.configErrors();
        while (i3.hasNext()) {
            buf.setLength(0);
            ++numberOfErrors;
            Report.ConfigurationError configurationError = i3.next();
            buf.append(this.redBold + "*" + this.colorReset + " rule: " + this.whiteBold + configurationError.rule().getName() + this.colorReset + PMD.EOL);
            buf.append(this.green + "    err:  " + this.cyan + configurationError.issue() + this.colorReset + PMD.EOL + PMD.EOL);
            this.writer.write(buf.toString());
        }
        if (numberOfErrors > 0) {
            this.writer.write(this.redBold + "*" + this.colorReset + " errors:   " + this.whiteBold + numberOfErrors + this.colorReset + PMD.EOL);
        }
        this.writer.write(this.yellowBold + "*" + this.colorReset + " warnings: " + this.whiteBold + numberOfWarnings + this.colorReset + PMD.EOL);
    }

    private String getLine(String sourceFile, int line) {
        String code = null;
        try (BufferedReader br = new BufferedReader(this.getReader(sourceFile));){
            for (int i = 0; line > i; ++i) {
                String txt = br.readLine();
                code = txt == null ? "" : txt.trim();
            }
        }
        catch (IOException ioErr) {
            ioErr.printStackTrace();
        }
        return code;
    }

    protected Reader getReader(String sourceFile) throws FileNotFoundException {
        try {
            return Files.newBufferedReader(new File(sourceFile).toPath(), Charset.defaultCharset());
        }
        catch (IOException e) {
            FileNotFoundException ex = new FileNotFoundException(sourceFile);
            ex.initCause(e);
            throw ex;
        }
    }

    private String getRelativePath(String fileName) {
        String relativePath;
        if (this.pwd == null) {
            try {
                this.pwd = new File(".").getCanonicalPath();
            }
            catch (IOException ioErr) {
                this.pwd = "";
            }
        }
        if (fileName.indexOf(this.pwd) == 0) {
            relativePath = "." + fileName.substring(this.pwd.length());
            if (relativePath.startsWith("." + File.separator + "." + File.separator)) {
                relativePath = relativePath.substring(2);
            }
        } else {
            relativePath = fileName;
        }
        return relativePath;
    }
}

