/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.lang.AbstractParser;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.VisitorStarter;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.xpath.Initializer;

@Deprecated
@InternalApi
public class SourceCodeProcessor {
    private static final Logger LOG = Logger.getLogger(SourceCodeProcessor.class.getName());
    private final PMDConfiguration configuration;

    public SourceCodeProcessor(PMDConfiguration configuration) {
        this.configuration = configuration;
    }

    public void processSourceCode(InputStream sourceCode, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        try (InputStreamReader streamReader = new InputStreamReader(sourceCode, this.configuration.getSourceEncoding());){
            this.processSourceCode(streamReader, ruleSets, ctx);
        }
        catch (IOException e) {
            throw new PMDException("IO exception: " + e.getMessage(), e);
        }
    }

    public void processSourceCode(Reader sourceCode, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        this.determineLanguage(ctx);
        Initializer.initialize();
        if (ruleSets.applies(ctx.getSourceCodeFile())) {
            if (this.isCacheUpToDate(ctx)) {
                this.reportCachedRuleViolations(ctx);
            } else {
                this.processSourceCodeWithoutCache(sourceCode, ruleSets, ctx);
            }
        }
    }

    private boolean isCacheUpToDate(RuleContext ctx) {
        return this.configuration.getAnalysisCache().isUpToDate(ctx.getSourceCodeFile());
    }

    private void reportCachedRuleViolations(RuleContext ctx) {
        for (RuleViolation rv : this.configuration.getAnalysisCache().getCachedViolations(ctx.getSourceCodeFile())) {
            ctx.getReport().addRuleViolation(rv);
        }
    }

    private void processSourceCodeWithoutCache(Reader sourceCode, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        block8: {
            try {
                ruleSets.start(ctx);
                this.processSource(sourceCode, ruleSets, ctx);
            }
            catch (ParseException pe) {
                this.configuration.getAnalysisCache().analysisFailed(ctx.getSourceCodeFile());
                if (this.configuration.isForceLanguageVersion()) {
                    LOG.log(Level.FINE, "Error while parsing " + ctx.getSourceCodeFile(), pe);
                    break block8;
                }
                throw new PMDException("Error while parsing " + ctx.getSourceCodeFile(), pe);
            }
            catch (Exception e) {
                this.configuration.getAnalysisCache().analysisFailed(ctx.getSourceCodeFile());
                throw new PMDException("Error while processing " + ctx.getSourceCodeFile(), e);
            }
            finally {
                ruleSets.end(ctx);
            }
        }
    }

    private Node parse(RuleContext ctx, Reader sourceCode, Parser parser) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.PARSER);){
            Node rootNode = AbstractParser.doParse(parser, String.valueOf(ctx.getSourceCodeFile()), sourceCode);
            ctx.getReport().suppress(parser.getSuppressMap());
            Node node = rootNode;
            return node;
        }
    }

    private void symbolFacade(Node rootNode, LanguageVersionHandler languageVersionHandler) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.SYMBOL_TABLE);){
            languageVersionHandler.getSymbolFacade(this.configuration.getClassLoader()).start(rootNode);
        }
    }

    private void resolveQualifiedNames(Node rootNode, LanguageVersionHandler handler) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.QUALIFIED_NAME_RESOLUTION);){
            handler.getQualifiedNameResolutionFacade(this.configuration.getClassLoader()).start(rootNode);
        }
    }

    private void usesDFA(LanguageVersion languageVersion, Node rootNode, RuleSets ruleSets, Language language) {
        if (ruleSets.usesDFA(language)) {
            try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.DFA);){
                VisitorStarter dataFlowFacade = languageVersion.getLanguageVersionHandler().getDataFlowFacade();
                dataFlowFacade.start(rootNode);
            }
        }
    }

    private void usesTypeResolution(LanguageVersion languageVersion, Node rootNode, RuleSets ruleSets, Language language) {
        if (ruleSets.usesTypeResolution(language)) {
            try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.TYPE_RESOLUTION);){
                languageVersion.getLanguageVersionHandler().getTypeResolutionFacade(this.configuration.getClassLoader()).start(rootNode);
            }
        }
    }

    private void usesMultifile(Node rootNode, LanguageVersionHandler languageVersionHandler, RuleSets ruleSets, Language language) {
        if (ruleSets.usesMultifile(language)) {
            try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.MULTIFILE_ANALYSIS);){
                languageVersionHandler.getMultifileFacade().start(rootNode);
            }
        }
    }

    private void processSource(Reader sourceCode, RuleSets ruleSets, RuleContext ctx) {
        LanguageVersion languageVersion = ctx.getLanguageVersion();
        LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
        Parser parser = PMD.parserFor(languageVersion, this.configuration);
        Node rootNode = this.parse(ctx, sourceCode, parser);
        this.resolveQualifiedNames(rootNode, languageVersionHandler);
        this.symbolFacade(rootNode, languageVersionHandler);
        Language language = languageVersion.getLanguage();
        this.usesDFA(languageVersion, rootNode, ruleSets, language);
        this.usesTypeResolution(languageVersion, rootNode, ruleSets, language);
        this.usesMultifile(rootNode, languageVersionHandler, ruleSets, language);
        List<Node> acus = Collections.singletonList(rootNode);
        ruleSets.apply(acus, ctx, language);
    }

    private void determineLanguage(RuleContext ctx) {
        if (ctx.getLanguageVersion() != null) {
            return;
        }
        LanguageVersion forceLanguage = this.configuration.getForceLanguageVersion();
        if (forceLanguage != null) {
            ctx.setLanguageVersion(forceLanguage);
        } else {
            LanguageVersion languageVersion = this.configuration.getLanguageVersionOfFile(ctx.getSourceCodeFilename());
            ctx.setLanguageVersion(languageVersion);
        }
    }
}

