/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.document.Document;
import net.sourceforge.pmd.document.DocumentOperation;
import net.sourceforge.pmd.document.RegionByLine;

public class DocumentOperationsApplierForNonOverlappingRegions {
    private static final Comparator<DocumentOperation> COMPARATOR = new DocumentOperationNonOverlappingRegionsComparator();
    private final Document document;
    private final List<DocumentOperation> operations;
    private boolean applied;

    public DocumentOperationsApplierForNonOverlappingRegions(Document document) {
        this.document = Objects.requireNonNull(document);
        this.operations = new ArrayList<DocumentOperation>();
        this.applied = false;
    }

    public void addDocumentOperation(DocumentOperation documentOperation) {
        this.assertOperationsHaveNotBeenApplied();
        int index = this.getIndexForDocumentOperation(Objects.requireNonNull(documentOperation));
        this.operations.add(index, documentOperation);
    }

    private void assertOperationsHaveNotBeenApplied() {
        if (this.applied) {
            throw new IllegalStateException("Document operations have already been applied to the document");
        }
    }

    private int getIndexForDocumentOperation(DocumentOperation documentOperation) {
        int potentialIndex = Collections.binarySearch(this.operations, documentOperation, COMPARATOR);
        if (potentialIndex < 0) {
            return ~potentialIndex;
        }
        int lastIndex = this.operations.size() - 1;
        while (potentialIndex < lastIndex && this.areSiblingsEqual(potentialIndex)) {
            ++potentialIndex;
        }
        return potentialIndex + 1;
    }

    private boolean areSiblingsEqual(int index) {
        return COMPARATOR.compare(this.operations.get(index), this.operations.get(index + 1)) == 0;
    }

    public void apply() {
        this.assertOperationsHaveNotBeenApplied();
        this.applied = true;
        for (DocumentOperation operation : this.operations) {
            operation.apply(this.document);
        }
    }

    private static class DocumentOperationNonOverlappingRegionsComparator
    implements Comparator<DocumentOperation> {
        private DocumentOperationNonOverlappingRegionsComparator() {
        }

        @Override
        public int compare(DocumentOperation o1, DocumentOperation o2) {
            int comparison;
            RegionByLine r2;
            RegionByLine r1 = Objects.requireNonNull(o1).getRegionByLine();
            if (this.operationsStartAtTheSameOffsetAndHaveZeroLength(r1, r2 = Objects.requireNonNull(o2).getRegionByLine())) {
                comparison = 0;
            } else if (this.doesFirstRegionEndBeforeSecondRegionBegins(r1, r2)) {
                comparison = -1;
            } else if (this.doesFirstRegionEndBeforeSecondRegionBegins(r2, r1)) {
                comparison = 1;
            } else {
                throw new IllegalArgumentException("Regions between document operations overlap, " + r1.toString() + "\n" + r2.toString());
            }
            return comparison;
        }

        private boolean operationsStartAtTheSameOffsetAndHaveZeroLength(RegionByLine r1, RegionByLine r2) {
            return r1.getBeginLine() == r2.getBeginLine() && r1.getBeginColumn() == r2.getBeginColumn() && r1.getBeginLine() == r1.getEndLine() && r1.getBeginColumn() == r1.getEndColumn();
        }

        private boolean doesFirstRegionEndBeforeSecondRegionBegins(RegionByLine r1, RegionByLine r2) {
            if (r1.getEndLine() < r2.getBeginLine()) {
                return true;
            }
            if (r1.getEndLine() == r2.getBeginLine()) {
                return r1.getEndColumn() <= r2.getBeginColumn();
            }
            return false;
        }
    }
}

