/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.List;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersionHandler;

public class LanguageVersion
implements Comparable<LanguageVersion> {
    private final Language language;
    private final String version;
    private final LanguageVersionHandler languageVersionHandler;

    @Deprecated
    @InternalApi
    public LanguageVersion(Language language, String version, LanguageVersionHandler languageVersionHandler) {
        this.language = language;
        this.version = version;
        this.languageVersionHandler = languageVersionHandler;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getVersion() {
        return this.version;
    }

    public LanguageVersionHandler getLanguageVersionHandler() {
        return this.languageVersionHandler;
    }

    public String getName() {
        return this.version.length() > 0 ? this.language.getName() + ' ' + this.version : this.language.getName();
    }

    public String getShortName() {
        return this.version.length() > 0 ? this.language.getShortName() + ' ' + this.version : this.language.getShortName();
    }

    public String getTerseName() {
        return this.version.length() > 0 ? this.language.getTerseName() + ' ' + this.version : this.language.getTerseName();
    }

    @Override
    public int compareTo(LanguageVersion o) {
        List<LanguageVersion> versions = this.language.getVersions();
        int thisPosition = versions.indexOf(this);
        int otherPosition = versions.indexOf(o);
        return Integer.compare(thisPosition, otherPosition);
    }

    public int compareToVersion(String versionString) {
        LanguageVersion otherVersion = this.language.getVersion(versionString);
        if (otherVersion == null) {
            throw new IllegalArgumentException("No such version '" + versionString + "' for language " + this.language.getName());
        }
        return this.compareTo(otherVersion);
    }

    public String toString() {
        return this.language.toString() + "+version:" + this.version;
    }
}

