/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.sort.DocumentSorter;

abstract class SaxonExprVisitor {
    SaxonExprVisitor() {
    }

    public Expression visit(DocumentSorter e) {
        Expression base = this.visit(e.getBaseExpression());
        return new DocumentSorter(base);
    }

    public Expression visit(PathExpression e) {
        Expression start = this.visit(e.getStartExpression());
        Expression step = this.visit(e.getStepExpression());
        return new PathExpression(start, step);
    }

    public Expression visit(RootExpression e) {
        return e;
    }

    public Expression visit(AxisExpression e) {
        return e;
    }

    public Expression visit(VennExpression e) {
        Expression[] operands = e.getOperands();
        Expression operand0 = this.visit(operands[0]);
        Expression operand1 = this.visit(operands[1]);
        return new VennExpression(operand0, e.getOperator(), operand1);
    }

    public Expression visit(FilterExpression e) {
        Expression base = this.visit(e.getBaseExpression());
        Expression filter = this.visit(e.getFilter());
        return new FilterExpression(base, filter);
    }

    public Expression visit(QuantifiedExpression e) {
        return e;
    }

    public Expression visit(LetExpression e) {
        Expression action = this.visit(e.getAction());
        Expression sequence = this.visit(e.getSequence());
        LetExpression result = new LetExpression();
        result.setAction(action);
        result.setSequence(sequence);
        result.setVariableQName(e.getVariableQName());
        result.setRequiredType(e.getRequiredType());
        result.setSlotNumber(e.getLocalSlotNumber());
        return result;
    }

    public Expression visit(LazyExpression e) {
        Expression base = this.visit(e.getBaseExpression());
        return LazyExpression.makeLazyExpression((Expression)base);
    }

    public Expression visit(BooleanExpression e) {
        Expression[] operands = e.getOperands();
        Expression operand0 = this.visit(operands[0]);
        Expression operand1 = this.visit(operands[1]);
        return new BooleanExpression(operand0, e.getOperator(), operand1);
    }

    public Expression visit(Expression expr) {
        Expression result = expr instanceof DocumentSorter ? this.visit((DocumentSorter)expr) : (expr instanceof PathExpression ? this.visit((PathExpression)expr) : (expr instanceof RootExpression ? this.visit((RootExpression)expr) : (expr instanceof AxisExpression ? this.visit((AxisExpression)expr) : (expr instanceof VennExpression ? this.visit((VennExpression)expr) : (expr instanceof FilterExpression ? this.visit((FilterExpression)expr) : (expr instanceof QuantifiedExpression ? this.visit((QuantifiedExpression)expr) : (expr instanceof LetExpression ? this.visit((LetExpression)expr) : (expr instanceof LazyExpression ? this.visit((LazyExpression)expr) : (expr instanceof BooleanExpression ? this.visit((BooleanExpression)expr) : expr)))))))));
        return result;
    }
}

