/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.ValueParserConstants;

public final class PropertyFactory {
    private PropertyFactory() {
    }

    public static PropertyBuilder.GenericPropertyBuilder<Integer> intProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Integer>(name, ValueParserConstants.INTEGER_PARSER, Integer.class);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<Integer, List<Integer>> intListProperty(String name) {
        return PropertyFactory.intProperty(name).toList().delim(',');
    }

    public static PropertyBuilder.GenericPropertyBuilder<Long> longIntProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Long>(name, ValueParserConstants.LONG_PARSER, Long.class);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<Long, List<Long>> longIntListProperty(String name) {
        return PropertyFactory.longIntProperty(name).toList().delim(',');
    }

    public static PropertyBuilder.GenericPropertyBuilder<Double> doubleProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Double>(name, ValueParserConstants.DOUBLE_PARSER, Double.class);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<Double, List<Double>> doubleListProperty(String name) {
        return PropertyFactory.doubleProperty(name).toList().delim(',');
    }

    public static PropertyBuilder.RegexPropertyBuilder regexProperty(String name) {
        return new PropertyBuilder.RegexPropertyBuilder(name);
    }

    public static PropertyBuilder.GenericPropertyBuilder<String> stringProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<String>(name, ValueParserConstants.STRING_PARSER, String.class);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<String, List<String>> stringListProperty(String name) {
        return PropertyFactory.stringProperty(name).toList();
    }

    public static PropertyBuilder.GenericPropertyBuilder<Character> charProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Character>(name, ValueParserConstants.CHARACTER_PARSER, Character.class);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<Character, List<Character>> charListProperty(String name) {
        return PropertyFactory.charProperty(name).toList();
    }

    public static PropertyBuilder.GenericPropertyBuilder<Boolean> booleanProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Boolean>(name, ValueParserConstants.BOOLEAN_PARSER, Boolean.class);
    }

    public static <T> PropertyBuilder.GenericPropertyBuilder<T> enumProperty(String name, Map<String, T> nameToValue) {
        return new PropertyBuilder.GenericPropertyBuilder<Object>(name, ValueParserConstants.enumerationParser(nameToValue), Object.class);
    }

    public static <T> PropertyBuilder.GenericCollectionPropertyBuilder<T, List<T>> enumListProperty(String name, Map<String, T> nameToValue) {
        return PropertyFactory.enumProperty(name, nameToValue).toList().delim('|');
    }
}

