/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.internal.DOMUtils;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptorField;
import net.sourceforge.pmd.properties.PropertyTypeId;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorExternalBuilder;
import net.sourceforge.pmd.rules.RuleBuilder;
import net.sourceforge.pmd.util.ResourceLoader;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@InternalApi
public class RuleFactory {
    private static final Logger LOG = Logger.getLogger(RuleFactory.class.getName());
    private static final String DEPRECATED = "deprecated";
    private static final String NAME = "name";
    private static final String MESSAGE = "message";
    private static final String EXTERNAL_INFO_URL = "externalInfoUrl";
    private static final String MINIMUM_LANGUAGE_VERSION = "minimumLanguageVersion";
    private static final String MAXIMUM_LANGUAGE_VERSION = "maximumLanguageVersion";
    private static final String SINCE = "since";
    private static final String PROPERTIES = "properties";
    private static final String PRIORITY = "priority";
    private static final String EXAMPLE = "example";
    private static final String DESCRIPTION = "description";
    private static final String PROPERTY = "property";
    private static final String CLASS = "class";
    private static final List<String> REQUIRED_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("name", "class"));
    private final ResourceLoader resourceLoader;

    @Deprecated
    public RuleFactory() {
        this(new ResourceLoader());
    }

    public RuleFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public RuleReference decorateRule(Rule referencedRule, RuleSetReference ruleSetReference, Element ruleElement) {
        RuleReference ruleReference = new RuleReference(referencedRule, ruleSetReference);
        if (ruleElement.hasAttribute(DEPRECATED)) {
            ruleReference.setDeprecated(Boolean.parseBoolean(ruleElement.getAttribute(DEPRECATED)));
        }
        if (ruleElement.hasAttribute(NAME)) {
            ruleReference.setName(ruleElement.getAttribute(NAME));
        }
        if (ruleElement.hasAttribute(MESSAGE)) {
            ruleReference.setMessage(ruleElement.getAttribute(MESSAGE));
        }
        if (ruleElement.hasAttribute(EXTERNAL_INFO_URL)) {
            ruleReference.setExternalInfoUrl(ruleElement.getAttribute(EXTERNAL_INFO_URL));
        }
        block12: for (int i = 0; i < ruleElement.getChildNodes().getLength(); ++i) {
            Node node = ruleElement.getChildNodes().item(i);
            if (node.getNodeType() != 1) continue;
            switch (node.getNodeName()) {
                case "description": {
                    ruleReference.setDescription(DOMUtils.parseTextNode(node));
                    continue block12;
                }
                case "example": {
                    ruleReference.addExample(DOMUtils.parseTextNode(node));
                    continue block12;
                }
                case "priority": {
                    ruleReference.setPriority(RulePriority.valueOf(Integer.parseInt(DOMUtils.parseTextNode(node))));
                    continue block12;
                }
                case "properties": {
                    this.setPropertyValues(ruleReference, (Element)node);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected element <" + node.getNodeName() + "> encountered as child of <rule> element for Rule " + ruleReference.getName());
                }
            }
        }
        return ruleReference;
    }

    public Rule buildRule(Element ruleElement) {
        Rule rule;
        this.checkRequiredAttributesArePresent(ruleElement);
        String name = ruleElement.getAttribute(NAME);
        RuleBuilder builder = new RuleBuilder(name, this.resourceLoader, ruleElement.getAttribute(CLASS), ruleElement.getAttribute("language"));
        if (ruleElement.hasAttribute(MINIMUM_LANGUAGE_VERSION)) {
            builder.minimumLanguageVersion(ruleElement.getAttribute(MINIMUM_LANGUAGE_VERSION));
        }
        if (ruleElement.hasAttribute(MAXIMUM_LANGUAGE_VERSION)) {
            builder.maximumLanguageVersion(ruleElement.getAttribute(MAXIMUM_LANGUAGE_VERSION));
        }
        if (ruleElement.hasAttribute(SINCE)) {
            builder.since(ruleElement.getAttribute(SINCE));
        }
        builder.message(ruleElement.getAttribute(MESSAGE));
        builder.externalInfoUrl(ruleElement.getAttribute(EXTERNAL_INFO_URL));
        builder.setDeprecated(RuleFactory.hasAttributeSetTrue(ruleElement, DEPRECATED));
        builder.usesDFA(RuleFactory.hasAttributeSetTrue(ruleElement, "dfa"));
        builder.usesTyperesolution(RuleFactory.hasAttributeSetTrue(ruleElement, "typeResolution"));
        Element propertiesElement = null;
        NodeList nodeList = ruleElement.getChildNodes();
        block14: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            switch (node.getNodeName()) {
                case "description": {
                    builder.description(DOMUtils.parseTextNode(node));
                    continue block14;
                }
                case "example": {
                    builder.addExample(DOMUtils.parseTextNode(node));
                    continue block14;
                }
                case "priority": {
                    builder.priority(Integer.parseInt(DOMUtils.parseTextNode(node).trim()));
                    continue block14;
                }
                case "properties": {
                    this.parsePropertiesForDefinitions(builder, node);
                    propertiesElement = (Element)node;
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected element <" + node.getNodeName() + "> encountered as child of <rule> element for Rule " + name);
                }
            }
        }
        try {
            rule = builder.build();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.log(Level.SEVERE, "Error instantiating a rule", e);
            throw new RuntimeException(e);
        }
        if (propertiesElement != null) {
            this.setPropertyValues(rule, propertiesElement);
        }
        return rule;
    }

    private void checkRequiredAttributesArePresent(Element ruleElement) {
        for (String att : REQUIRED_ATTRIBUTES) {
            if (ruleElement.hasAttribute(att)) continue;
            throw new IllegalArgumentException("Missing '" + att + "' attribute");
        }
    }

    private Map<String, String> getPropertyValuesFrom(Element propertiesNode) {
        HashMap<String, String> overriddenProperties = new HashMap<String, String>();
        for (int i = 0; i < propertiesNode.getChildNodes().getLength(); ++i) {
            Node node = propertiesNode.getChildNodes().item(i);
            if (node.getNodeType() != 1 || !PROPERTY.equals(node.getNodeName())) continue;
            Map.Entry<String, String> overridden = this.getPropertyValue((Element)node);
            overriddenProperties.put(overridden.getKey(), overridden.getValue());
        }
        return overriddenProperties;
    }

    private void parsePropertiesForDefinitions(RuleBuilder builder, Node propertiesNode) {
        for (int i = 0; i < propertiesNode.getChildNodes().getLength(); ++i) {
            Node node = propertiesNode.getChildNodes().item(i);
            if (node.getNodeType() != 1 || !PROPERTY.equals(node.getNodeName()) || !RuleFactory.isPropertyDefinition((Element)node)) continue;
            PropertyDescriptor<?> descriptor = RuleFactory.parsePropertyDefinition((Element)node);
            builder.defineProperty(descriptor);
        }
    }

    private Map.Entry<String, String> getPropertyValue(Element propertyElement) {
        String name = propertyElement.getAttribute(PropertyDescriptorField.NAME.attributeName());
        return new AbstractMap.SimpleEntry<String, String>(name, RuleFactory.valueFrom(propertyElement));
    }

    private void setPropertyValues(Rule rule, Element propertiesElt) {
        Map<String, String> overridden = this.getPropertyValuesFrom(propertiesElt);
        for (Map.Entry<String, String> e : overridden.entrySet()) {
            PropertyDescriptor<?> descriptor = rule.getPropertyDescriptor(e.getKey());
            if (descriptor == null) {
                throw new IllegalArgumentException("Cannot set non-existent property '" + e.getKey() + "' on Rule " + rule.getName());
            }
            this.setRulePropertyCapture(rule, descriptor, e.getValue());
        }
    }

    private <T> void setRulePropertyCapture(Rule rule, PropertyDescriptor<T> descriptor, String value) {
        rule.setProperty(descriptor, descriptor.valueFrom(value));
    }

    private static boolean isPropertyDefinition(Element node) {
        return node.hasAttribute(PropertyDescriptorField.TYPE.attributeName());
    }

    private static PropertyDescriptor<?> parsePropertyDefinition(Element propertyElement) {
        String typeId = propertyElement.getAttribute(PropertyDescriptorField.TYPE.attributeName());
        PropertyDescriptorExternalBuilder<?> pdFactory = PropertyTypeId.factoryFor(typeId);
        if (pdFactory == null) {
            throw new IllegalArgumentException("No property descriptor factory for type: " + typeId);
        }
        HashMap<PropertyDescriptorField, String> values = new HashMap<PropertyDescriptorField, String>();
        NamedNodeMap atts = propertyElement.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            values.put(PropertyDescriptorField.getConstant(a.getName()), a.getValue());
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)values.get((Object)PropertyDescriptorField.DEFAULT_VALUE)))) {
            NodeList children = propertyElement.getElementsByTagName(PropertyDescriptorField.DEFAULT_VALUE.attributeName());
            if (children.getLength() == 1) {
                values.put(PropertyDescriptorField.DEFAULT_VALUE, children.item(0).getTextContent());
            } else {
                throw new IllegalArgumentException("No value defined!");
            }
        }
        return pdFactory.build(values);
    }

    private static String valueFrom(Element propertyNode) {
        String strValue = propertyNode.getAttribute(PropertyDescriptorField.DEFAULT_VALUE.attributeName());
        if (StringUtils.isNotBlank((CharSequence)strValue)) {
            return strValue;
        }
        NodeList nodeList = propertyNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"value".equals(node.getNodeName())) continue;
            return DOMUtils.parseTextNode(node);
        }
        return null;
    }

    private static boolean hasAttributeSetTrue(Element element, String attributeId) {
        return element.hasAttribute(attributeId) && "true".equalsIgnoreCase(element.getAttribute(attributeId));
    }
}

