/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PMDVersion {
    private static final Logger LOG = Logger.getLogger(PMDVersion.class.getName());
    public static final String VERSION;
    private static final String UNKNOWN_VERSION = "unknown";

    private PMDVersion() {
        throw new AssertionError((Object)"Can't instantiate utility classes");
    }

    public static String getNextMajorRelease() {
        if (PMDVersion.isUnknown()) {
            return UNKNOWN_VERSION;
        }
        int major = Integer.parseInt(VERSION.split("\\.")[0]);
        return major + 1 + ".0.0";
    }

    public static boolean isUnknown() {
        return UNKNOWN_VERSION.equals(VERSION);
    }

    public static boolean isSnapshot() {
        return VERSION.endsWith("-SNAPSHOT");
    }

    static {
        String pmdVersion = UNKNOWN_VERSION;
        try (InputStream stream = PMDVersion.class.getResourceAsStream("/META-INF/maven/net.sourceforge.pmd/pmd-core/pom.properties");){
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                pmdVersion = properties.getProperty("version");
            }
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Couldn't determine version of PMD", e);
        }
        VERSION = pmdVersion;
    }
}

