/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetLoader;
import net.sourceforge.pmd.ant.Formatter;
import net.sourceforge.pmd.ant.PMDTask;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.log.AntLogHandler;
import net.sourceforge.pmd.util.log.ScopedLogHandlersManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class PMDTaskImpl {
    private Path classpath;
    private Path auxClasspath;
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final PMDConfiguration configuration = new PMDConfiguration();
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private int maxRuleViolations = 0;
    private String failuresPropertyName;
    private Project project;

    public PMDTaskImpl(PMDTask task) {
        this.configuration.setReportShortNames(task.isShortFilenames());
        this.configuration.setSuppressMarker(task.getSuppressMarker());
        this.failOnError = task.isFailOnError();
        this.failOnRuleViolation = task.isFailOnRuleViolation();
        this.maxRuleViolations = task.getMaxRuleViolations();
        if (this.maxRuleViolations > 0) {
            this.failOnRuleViolation = true;
        }
        this.configuration.setRuleSets(task.getRulesetFiles());
        this.configuration.setRuleSetFactoryCompatibilityEnabled(!task.isNoRuleSetCompatibility());
        if (task.getEncoding() != null) {
            this.configuration.setSourceEncoding(task.getEncoding());
        }
        this.configuration.setThreads(task.getThreads());
        this.failuresPropertyName = task.getFailuresPropertyName();
        this.configuration.setMinimumPriority(RulePriority.valueOf(task.getMinimumPriority()));
        this.configuration.setAnalysisCacheLocation(task.getCacheLocation());
        this.configuration.setIgnoreIncrementalAnalysis(task.isNoCache());
        SourceLanguage version = task.getSourceLanguage();
        if (version != null) {
            LanguageVersion languageVersion = LanguageRegistry.findLanguageVersionByTerseName(version.getName() + ' ' + version.getVersion());
            if (languageVersion == null) {
                throw new BuildException("The following language is not supported:" + version + '.');
            }
            this.configuration.setDefaultLanguageVersion(languageVersion);
        }
        this.classpath = task.getClasspath();
        this.auxClasspath = task.getAuxClasspath();
        this.filesets.addAll(task.getFilesets());
        this.formatters.addAll(task.getFormatters());
        this.project = task.getProject();
    }

    private void doTask() {
        Report report;
        this.setupClassLoader();
        if (this.configuration.getSuppressMarker() != null) {
            this.project.log("Setting suppress marker to be " + this.configuration.getSuppressMarker(), 3);
        }
        ArrayList<String> reportShortNamesPaths = new ArrayList<String>();
        ArrayList<String> fullInputPath = new ArrayList<String>();
        List<String> ruleSetPaths = this.expandRuleSetPaths();
        this.configuration.setRuleSets(Collections.emptyList());
        try (PmdAnalysis pmd = PmdAnalysis.create(this.configuration);){
            RuleSetLoader rulesetLoader = pmd.newRuleSetLoader().loadResourcesWith(this.setupResourceLoader());
            pmd.addRuleSets(rulesetLoader.loadRuleSetsWithoutException(ruleSetPaths));
            for (FileSet fileset : this.filesets) {
                DirectoryScanner ds = fileset.getDirectoryScanner(this.project);
                for (String srcFile : ds.getIncludedFiles()) {
                    pmd.files().addFile(ds.getBasedir().toPath().resolve(srcFile));
                }
                String commonInputPath = ds.getBasedir().getPath();
                fullInputPath.add(commonInputPath);
                if (!this.configuration.isReportShortNames()) continue;
                reportShortNamesPaths.add(commonInputPath);
            }
            for (Formatter formatter : this.formatters) {
                this.project.log("Sending a report to " + formatter, 3);
                pmd.addRenderer(formatter.toRenderer(this.project, reportShortNamesPaths));
            }
            pmd.addRenderer(this.getLogRenderer(StringUtils.join(fullInputPath, (String)",")));
            report = pmd.performAnalysisAndCollectReport();
            if (this.failOnError && pmd.getReporter().numErrors() > 0) {
                throw new BuildException("Some errors occurred while running PMD");
            }
        }
        int problemCount = report.getViolations().size();
        this.project.log(problemCount + " problems found", 3);
        if (this.failuresPropertyName != null && problemCount > 0) {
            this.project.setProperty(this.failuresPropertyName, String.valueOf(problemCount));
            this.project.log("Setting property " + this.failuresPropertyName + " to " + problemCount, 3);
        }
        if (this.failOnRuleViolation && problemCount > this.maxRuleViolations) {
            throw new BuildException("Stopping build since PMD found " + problemCount + " rule violations in the code");
        }
    }

    private List<String> expandRuleSetPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.configuration.getRuleSetPaths());
        for (int i = 0; i < paths.size(); ++i) {
            paths.set(i, this.project.replaceProperties((String)paths.get(i)));
        }
        return paths;
    }

    private AbstractRenderer getLogRenderer(final String commonInputPath) {
        return new AbstractRenderer("log", "Logging renderer"){

            @Override
            public void start() {
            }

            @Override
            public void startFileAnalysis(DataSource dataSource) {
                PMDTaskImpl.this.project.log("Processing file " + dataSource.getNiceFileName(false, commonInputPath), 3);
            }

            @Override
            public void renderFileReport(Report r) {
            }

            @Override
            public void end() {
            }

            @Override
            public void flush() {
            }

            @Override
            public String defaultFileExtension() {
                return null;
            }
        };
    }

    private ClassLoader setupResourceLoader() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        this.classpath.add(new Path(null, this.project.getBaseDir().toString()));
        this.project.log("Using the AntClassLoader: " + this.classpath, 3);
        boolean parentFirst = true;
        return new AntClassLoader(Thread.currentThread().getContextClassLoader(), this.project, this.classpath, true);
    }

    private void setupClassLoader() {
        try {
            if (this.auxClasspath != null) {
                this.project.log("Using auxclasspath: " + this.auxClasspath, 3);
                this.configuration.prependAuxClasspath(this.auxClasspath.toString());
            }
        }
        catch (IllegalArgumentException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void execute() throws BuildException {
        AntLogHandler antLogHandler = new AntLogHandler(this.project);
        ScopedLogHandlersManager logManager = new ScopedLogHandlersManager(antLogHandler.getAntLogLevel(), antLogHandler);
        try {
            this.doTask();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception other) {
            throw new BuildException((Throwable)other);
        }
        finally {
            logManager.close();
            if (this.configuration.getClassLoader() instanceof ClasspathClassLoader) {
                IOUtil.tryCloseClassLoader(this.configuration.getClassLoader());
            }
        }
    }
}

