/*
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */

package net.sourceforge.pmd.renderers.internal.sarif;

import java.util.List;
import java.util.Set;

import com.google.gson.annotations.SerializedName;

// Generated by delombok at Mon Jan 25 09:12:45 CET 2021
// CPD-OFF
public class SarifLog {
    /**
     * The URI of the JSON schema corresponding to the version.
     */
    @SerializedName("$schema")
    private String schema;
    /**
     * The SARIF format version of this log file.
     */
    private String version;
    /**
     * The set of runs contained in this log file.
     */
    private List<Run> runs;


    /**
     * A location within a programming artifact.
     */
    public static class Location {
        /**
         * Value that distinguishes this location from all other locations within a single result object.
         */
        private Integer id;
        /**
         * Identifies the artifact and region.
         */
        private PhysicalLocation physicalLocation;

        @java.lang.SuppressWarnings("all")
        Location(final Integer id, final PhysicalLocation physicalLocation) {
            this.id = id;
            this.physicalLocation = physicalLocation;
        }


        @java.lang.SuppressWarnings("all")
        public static class LocationBuilder {
            @java.lang.SuppressWarnings("all")
            private Integer id;
            @java.lang.SuppressWarnings("all")
            private PhysicalLocation physicalLocation;

            @java.lang.SuppressWarnings("all")
            LocationBuilder() {
            }

            /**
             * Value that distinguishes this location from all other locations within a single result object.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Location.LocationBuilder id(final Integer id) {
                this.id = id;
                return this;
            }

            /**
             * Identifies the artifact and region.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Location.LocationBuilder physicalLocation(final PhysicalLocation physicalLocation) {
                this.physicalLocation = physicalLocation;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Location build() {
                return new SarifLog.Location(this.id, this.physicalLocation);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Location.LocationBuilder(id=" + this.id + ", physicalLocation=" + this.physicalLocation + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Location.LocationBuilder builder() {
            return new SarifLog.Location.LocationBuilder();
        }

        /**
         * Value that distinguishes this location from all other locations within a single result object.
         */
        @java.lang.SuppressWarnings("all")
        public Integer getId() {
            return this.id;
        }

        /**
         * Identifies the artifact and region.
         */
        @java.lang.SuppressWarnings("all")
        public PhysicalLocation getPhysicalLocation() {
            return this.physicalLocation;
        }

        /**
         * Value that distinguishes this location from all other locations within a single result object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Location setId(final Integer id) {
            this.id = id;
            return this;
        }

        /**
         * Identifies the artifact and region.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Location setPhysicalLocation(final PhysicalLocation physicalLocation) {
            this.physicalLocation = physicalLocation;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Location)) {
                return false;
            }
            final SarifLog.Location other = (SarifLog.Location) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            final java.lang.Object this$physicalLocation = this.getPhysicalLocation();
            final java.lang.Object other$physicalLocation = other.getPhysicalLocation();
            if (this$physicalLocation == null ? other$physicalLocation != null : !this$physicalLocation.equals(other$physicalLocation)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Location;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $physicalLocation = this.getPhysicalLocation();
            result = result * PRIME + ($physicalLocation == null ? 43 : $physicalLocation.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Location(id=" + this.getId() + ", physicalLocation=" + this.getPhysicalLocation() + ")";
        }
    }


    /**
     * Specifies the location of an artifact.
     */
    public static class ArtifactLocation {
        /**
         * A string containing a valid relative or absolute URI.
         */
        private String uri;
        /**
         * A string which indirectly specifies the absolute URI with respect to which a relative URI in the "uri" property
         * is interpreted.
         */
        private String uriBaseId;
        /**
         * The index within the run artifacts array of the artifact object associated with the artifact location.
         */
        private Integer index;

        @java.lang.SuppressWarnings("all")
        ArtifactLocation(final String uri, final String uriBaseId, final Integer index) {
            this.uri = uri;
            this.uriBaseId = uriBaseId;
            this.index = index;
        }


        @java.lang.SuppressWarnings("all")
        public static class ArtifactLocationBuilder {
            @java.lang.SuppressWarnings("all")
            private String uri;
            @java.lang.SuppressWarnings("all")
            private String uriBaseId;
            @java.lang.SuppressWarnings("all")
            private Integer index;

            @java.lang.SuppressWarnings("all")
            ArtifactLocationBuilder() {
            }

            /**
             * A string containing a valid relative or absolute URI.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ArtifactLocation.ArtifactLocationBuilder uri(final String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * A string which indirectly specifies the absolute URI with respect to which a relative URI in the "uri" property
             * is interpreted.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ArtifactLocation.ArtifactLocationBuilder uriBaseId(final String uriBaseId) {
                this.uriBaseId = uriBaseId;
                return this;
            }

            /**
             * The index within the run artifacts array of the artifact object associated with the artifact location.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ArtifactLocation.ArtifactLocationBuilder index(final Integer index) {
                this.index = index;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.ArtifactLocation build() {
                return new SarifLog.ArtifactLocation(this.uri, this.uriBaseId, this.index);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.ArtifactLocation.ArtifactLocationBuilder(uri=" + this.uri + ", uriBaseId=" + this.uriBaseId + ", index=" + this.index + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.ArtifactLocation.ArtifactLocationBuilder builder() {
            return new SarifLog.ArtifactLocation.ArtifactLocationBuilder();
        }

        /**
         * A string containing a valid relative or absolute URI.
         */
        @java.lang.SuppressWarnings("all")
        public String getUri() {
            return this.uri;
        }

        /**
         * A string which indirectly specifies the absolute URI with respect to which a relative URI in the "uri" property
         * is interpreted.
         */
        @java.lang.SuppressWarnings("all")
        public String getUriBaseId() {
            return this.uriBaseId;
        }

        /**
         * The index within the run artifacts array of the artifact object associated with the artifact location.
         */
        @java.lang.SuppressWarnings("all")
        public Integer getIndex() {
            return this.index;
        }

        /**
         * A string containing a valid relative or absolute URI.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ArtifactLocation setUri(final String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * A string which indirectly specifies the absolute URI with respect to which a relative URI in the "uri" property
         * is interpreted.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ArtifactLocation setUriBaseId(final String uriBaseId) {
            this.uriBaseId = uriBaseId;
            return this;
        }

        /**
         * The index within the run artifacts array of the artifact object associated with the artifact location.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ArtifactLocation setIndex(final Integer index) {
            this.index = index;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.ArtifactLocation)) {
                return false;
            }
            final SarifLog.ArtifactLocation other = (SarifLog.ArtifactLocation) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$uri = this.getUri();
            final java.lang.Object other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            final java.lang.Object this$uriBaseId = this.getUriBaseId();
            final java.lang.Object other$uriBaseId = other.getUriBaseId();
            if (this$uriBaseId == null ? other$uriBaseId != null : !this$uriBaseId.equals(other$uriBaseId)) {
                return false;
            }
            final java.lang.Object this$index = this.getIndex();
            final java.lang.Object other$index = other.getIndex();
            if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.ArtifactLocation;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $uri = this.getUri();
            result = result * PRIME + ($uri == null ? 43 : $uri.hashCode());
            final java.lang.Object $uriBaseId = this.getUriBaseId();
            result = result * PRIME + ($uriBaseId == null ? 43 : $uriBaseId.hashCode());
            final java.lang.Object $index = this.getIndex();
            result = result * PRIME + ($index == null ? 43 : $index.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.ArtifactLocation(uri=" + this.getUri() + ", uriBaseId=" + this.getUriBaseId() + ", index=" + this.getIndex() + ")";
        }
    }


    /**
     * A physical location relevant to a result. Specifies a reference to a programming artifact together with a range
     * of bytes or characters within that artifact.
     */
    public static class PhysicalLocation {
        /**
         * The location of the artifact.
         */
        private ArtifactLocation artifactLocation;
        /**
         * Specifies a portion of the artifact.
         */
        private Region region;

        @java.lang.SuppressWarnings("all")
        PhysicalLocation(final ArtifactLocation artifactLocation, final Region region) {
            this.artifactLocation = artifactLocation;
            this.region = region;
        }


        @java.lang.SuppressWarnings("all")
        public static class PhysicalLocationBuilder {
            @java.lang.SuppressWarnings("all")
            private ArtifactLocation artifactLocation;
            @java.lang.SuppressWarnings("all")
            private Region region;

            @java.lang.SuppressWarnings("all")
            PhysicalLocationBuilder() {
            }

            /**
             * The location of the artifact.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.PhysicalLocation.PhysicalLocationBuilder artifactLocation(final ArtifactLocation artifactLocation) {
                this.artifactLocation = artifactLocation;
                return this;
            }

            /**
             * Specifies a portion of the artifact.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.PhysicalLocation.PhysicalLocationBuilder region(final Region region) {
                this.region = region;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.PhysicalLocation build() {
                return new SarifLog.PhysicalLocation(this.artifactLocation, this.region);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.PhysicalLocation.PhysicalLocationBuilder(artifactLocation=" + this.artifactLocation + ", region=" + this.region + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.PhysicalLocation.PhysicalLocationBuilder builder() {
            return new SarifLog.PhysicalLocation.PhysicalLocationBuilder();
        }

        /**
         * The location of the artifact.
         */
        @java.lang.SuppressWarnings("all")
        public ArtifactLocation getArtifactLocation() {
            return this.artifactLocation;
        }

        /**
         * Specifies a portion of the artifact.
         */
        @java.lang.SuppressWarnings("all")
        public Region getRegion() {
            return this.region;
        }

        /**
         * The location of the artifact.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.PhysicalLocation setArtifactLocation(final ArtifactLocation artifactLocation) {
            this.artifactLocation = artifactLocation;
            return this;
        }

        /**
         * Specifies a portion of the artifact.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.PhysicalLocation setRegion(final Region region) {
            this.region = region;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.PhysicalLocation)) {
                return false;
            }
            final SarifLog.PhysicalLocation other = (SarifLog.PhysicalLocation) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$artifactLocation = this.getArtifactLocation();
            final java.lang.Object other$artifactLocation = other.getArtifactLocation();
            if (this$artifactLocation == null ? other$artifactLocation != null : !this$artifactLocation.equals(other$artifactLocation)) {
                return false;
            }
            final java.lang.Object this$region = this.getRegion();
            final java.lang.Object other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.PhysicalLocation;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $artifactLocation = this.getArtifactLocation();
            result = result * PRIME + ($artifactLocation == null ? 43 : $artifactLocation.hashCode());
            final java.lang.Object $region = this.getRegion();
            result = result * PRIME + ($region == null ? 43 : $region.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.PhysicalLocation(artifactLocation=" + this.getArtifactLocation() + ", region=" + this.getRegion() + ")";
        }
    }


    /**
     * Key/value pairs that provide additional information about the object.
     */
    public static class PropertyBag {
        /**
         * The name of the rule set.
         */
        private String ruleset;
        /**
         * The pmd priority of the rule.
         */
        private Integer priority;
        /**
         * A set of distinct strings that provide additional information. This is SARIF 2.1.0 Schema.
         */
        private Set<String> tags;

        @java.lang.SuppressWarnings("all")
        PropertyBag(final String ruleset, final Integer priority, final Set<String> tags) {
            this.ruleset = ruleset;
            this.priority = priority;
            this.tags = tags;
        }


        @java.lang.SuppressWarnings("all")
        public static class PropertyBagBuilder {
            @java.lang.SuppressWarnings("all")
            private String ruleset;
            @java.lang.SuppressWarnings("all")
            private Integer priority;
            @java.lang.SuppressWarnings("all")
            private Set<String> tags;

            @java.lang.SuppressWarnings("all")
            PropertyBagBuilder() {
            }

            /**
             * The name of the rule set.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.PropertyBag.PropertyBagBuilder ruleset(final String ruleset) {
                this.ruleset = ruleset;
                return this;
            }

            /**
             * The pmd priority of the rule.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.PropertyBag.PropertyBagBuilder priority(final Integer priority) {
                this.priority = priority;
                return this;
            }

            /**
             * A set of distinct strings that provide additional information. This is SARIF 2.1.0 Schema.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.PropertyBag.PropertyBagBuilder tags(final Set<String> tags) {
                this.tags = tags;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.PropertyBag build() {
                return new SarifLog.PropertyBag(this.ruleset, this.priority, this.tags);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.PropertyBag.PropertyBagBuilder(ruleset=" + this.ruleset + ", priority=" + this.priority + ", tags=" + this.tags + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.PropertyBag.PropertyBagBuilder builder() {
            return new SarifLog.PropertyBag.PropertyBagBuilder();
        }

        /**
         * The name of the rule set.
         */
        @java.lang.SuppressWarnings("all")
        public String getRuleset() {
            return this.ruleset;
        }

        /**
         * The pmd priority of the rule.
         */
        @java.lang.SuppressWarnings("all")
        public Integer getPriority() {
            return this.priority;
        }

        /**
         * A set of distinct strings that provide additional information. This is SARIF 2.1.0 Schema.
         */
        @java.lang.SuppressWarnings("all")
        public Set<String> getTags() {
            return this.tags;
        }

        /**
         * The name of the rule set.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.PropertyBag setRuleset(final String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        /**
         * The pmd priority of the rule.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.PropertyBag setPriority(final Integer priority) {
            this.priority = priority;
            return this;
        }

        /**
         * The set of distinct strings that provide additional information. This is SARIF 2.1.0 Schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.PropertyBag setTags(final Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.PropertyBag)) {
                return false;
            }
            final SarifLog.PropertyBag other = (SarifLog.PropertyBag) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$ruleset = this.getRuleset();
            final java.lang.Object other$ruleset = other.getRuleset();
            if (this$ruleset == null ? other$ruleset != null : !this$ruleset.equals(other$ruleset)) {
                return false;
            }
            final java.lang.Object this$priority = this.getPriority();
            final java.lang.Object other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
                return false;
            }
            final java.lang.Object this$tags = this.getTags();
            final java.lang.Object other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.PropertyBag;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $ruleset = this.getRuleset();
            result = result * PRIME + ($ruleset == null ? 43 : $ruleset.hashCode());
            final java.lang.Object $priority = this.getPriority();
            result = result * PRIME + ($priority == null ? 43 : $priority.hashCode());
            final java.lang.Object $tags = this.getTags();
            result = result * PRIME + ($tags == null ? 43 : $tags.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.PropertyBag(ruleset=" + this.getRuleset() + ", priority=" + this.getPriority() + ", tags=" + this.getTags() + ")";
        }
    }


    /**
     * A region within an artifact where a result was detected.
     */
    public static class Region {
        /**
         * The line number of the first character in the region.
         */
        private Integer startLine;
        /**
         * The column number of the first character in the region.
         */
        private Integer startColumn;
        /**
         * The line number of the last character in the region.
         */
        private Integer endLine;
        /**
         * The column number of the character following the end of the region.
         */
        private Integer endColumn;

        @java.lang.SuppressWarnings("all")
        Region(final Integer startLine, final Integer startColumn, final Integer endLine, final Integer endColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }


        @java.lang.SuppressWarnings("all")
        public static class RegionBuilder {
            @java.lang.SuppressWarnings("all")
            private Integer startLine;
            @java.lang.SuppressWarnings("all")
            private Integer startColumn;
            @java.lang.SuppressWarnings("all")
            private Integer endLine;
            @java.lang.SuppressWarnings("all")
            private Integer endColumn;

            @java.lang.SuppressWarnings("all")
            RegionBuilder() {
            }

            /**
             * The line number of the first character in the region.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Region.RegionBuilder startLine(final Integer startLine) {
                this.startLine = startLine;
                return this;
            }

            /**
             * The column number of the first character in the region.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Region.RegionBuilder startColumn(final Integer startColumn) {
                this.startColumn = startColumn;
                return this;
            }

            /**
             * The line number of the last character in the region.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Region.RegionBuilder endLine(final Integer endLine) {
                this.endLine = endLine;
                return this;
            }

            /**
             * The column number of the character following the end of the region.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Region.RegionBuilder endColumn(final Integer endColumn) {
                this.endColumn = endColumn;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Region build() {
                return new SarifLog.Region(this.startLine, this.startColumn, this.endLine, this.endColumn);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Region.RegionBuilder(startLine=" + this.startLine + ", startColumn=" + this.startColumn + ", endLine=" + this.endLine + ", endColumn=" + this.endColumn + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Region.RegionBuilder builder() {
            return new SarifLog.Region.RegionBuilder();
        }

        /**
         * The line number of the first character in the region.
         */
        @java.lang.SuppressWarnings("all")
        public Integer getStartLine() {
            return this.startLine;
        }

        /**
         * The column number of the first character in the region.
         */
        @java.lang.SuppressWarnings("all")
        public Integer getStartColumn() {
            return this.startColumn;
        }

        /**
         * The line number of the last character in the region.
         */
        @java.lang.SuppressWarnings("all")
        public Integer getEndLine() {
            return this.endLine;
        }

        /**
         * The column number of the character following the end of the region.
         */
        @java.lang.SuppressWarnings("all")
        public Integer getEndColumn() {
            return this.endColumn;
        }

        /**
         * The line number of the first character in the region.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Region setStartLine(final Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        /**
         * The column number of the first character in the region.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Region setStartColumn(final Integer startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        /**
         * The line number of the last character in the region.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Region setEndLine(final Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        /**
         * The column number of the character following the end of the region.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Region setEndColumn(final Integer endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Region)) {
                return false;
            }
            final SarifLog.Region other = (SarifLog.Region) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$startLine = this.getStartLine();
            final java.lang.Object other$startLine = other.getStartLine();
            if (this$startLine == null ? other$startLine != null : !this$startLine.equals(other$startLine)) {
                return false;
            }
            final java.lang.Object this$startColumn = this.getStartColumn();
            final java.lang.Object other$startColumn = other.getStartColumn();
            if (this$startColumn == null ? other$startColumn != null : !this$startColumn.equals(other$startColumn)) {
                return false;
            }
            final java.lang.Object this$endLine = this.getEndLine();
            final java.lang.Object other$endLine = other.getEndLine();
            if (this$endLine == null ? other$endLine != null : !this$endLine.equals(other$endLine)) {
                return false;
            }
            final java.lang.Object this$endColumn = this.getEndColumn();
            final java.lang.Object other$endColumn = other.getEndColumn();
            if (this$endColumn == null ? other$endColumn != null : !this$endColumn.equals(other$endColumn)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Region;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $startLine = this.getStartLine();
            result = result * PRIME + ($startLine == null ? 43 : $startLine.hashCode());
            final java.lang.Object $startColumn = this.getStartColumn();
            result = result * PRIME + ($startColumn == null ? 43 : $startColumn.hashCode());
            final java.lang.Object $endLine = this.getEndLine();
            result = result * PRIME + ($endLine == null ? 43 : $endLine.hashCode());
            final java.lang.Object $endColumn = this.getEndColumn();
            result = result * PRIME + ($endColumn == null ? 43 : $endColumn.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Region(startLine=" + this.getStartLine() + ", startColumn=" + this.getStartColumn() + ", endLine=" + this.getEndLine() + ", endColumn=" + this.getEndColumn() + ")";
        }
    }


    /**
     * A result produced by an analysis tool.
     */
    public static class Result {
        /**
         * The stable, unique identifier of the rule, if any, to which this result is relevant.
         */
        private String ruleId;
        /**
         * The index link the rule, if any, to which this result is relevant.
         */
        private Integer ruleIndex;
        /**
         * A message that describes the result. The first sentence of the message only will be displayed when visible
         * space is limited.
         */
        private Message message;
        /**
         * The set of locations where the result was detected. Specify only one location unless the problem indicated by
         * the result can only be corrected by making a change at every specified location.
         */
        private List<Location> locations;
        /**
         * Key/value pairs that provide additional information about the address.
         */
        private PropertyBag properties;

        @java.lang.SuppressWarnings("all")
        Result(final String ruleId, final Integer ruleIndex, final Message message, final List<Location> locations, final PropertyBag properties) {
            this.ruleId = ruleId;
            this.ruleIndex = ruleIndex;
            this.message = message;
            this.locations = locations;
            this.properties = properties;
        }


        @java.lang.SuppressWarnings("all")
        public static class ResultBuilder {
            @java.lang.SuppressWarnings("all")
            private String ruleId;
            @java.lang.SuppressWarnings("all")
            private Integer ruleIndex;
            @java.lang.SuppressWarnings("all")
            private Message message;
            @java.lang.SuppressWarnings("all")
            private List<Location> locations;
            @java.lang.SuppressWarnings("all")
            private PropertyBag properties;

            @java.lang.SuppressWarnings("all")
            ResultBuilder() {
            }

            /**
             * The stable, unique identifier of the rule, if any, to which this result is relevant.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Result.ResultBuilder ruleId(final String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            /**
             * The index link the rule, if any, to which this result is relevant.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Result.ResultBuilder ruleIndex(final Integer ruleIndex) {
                this.ruleIndex = ruleIndex;
                return this;
            }

            /**
             * A message that describes the result. The first sentence of the message only will be displayed when visible
             * space is limited.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Result.ResultBuilder message(final Message message) {
                this.message = message;
                return this;
            }

            /**
             * The set of locations where the result was detected. Specify only one location unless the problem indicated by
             * the result can only be corrected by making a change at every specified location.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Result.ResultBuilder locations(final List<Location> locations) {
                this.locations = locations;
                return this;
            }

            /**
             * Key/value pairs that provide additional information about the address.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Result.ResultBuilder properties(final PropertyBag properties) {
                this.properties = properties;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Result build() {
                return new SarifLog.Result(this.ruleId, this.ruleIndex, this.message, this.locations, this.properties);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Result.ResultBuilder(ruleId=" + this.ruleId + ", ruleIndex=" + this.ruleIndex + ", message=" + this.message + ", locations=" + this.locations + ", properties=" + this.properties + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Result.ResultBuilder builder() {
            return new SarifLog.Result.ResultBuilder();
        }

        /**
         * The stable, unique identifier of the rule, if any, to which this result is relevant.
         */
        @java.lang.SuppressWarnings("all")
        public String getRuleId() {
            return this.ruleId;
        }

        /**
         * The index link the rule, if any, to which this result is relevant.
         */
        @java.lang.SuppressWarnings("all")
        public Integer getRuleIndex() {
            return this.ruleIndex;
        }

        /**
         * A message that describes the result. The first sentence of the message only will be displayed when visible
         * space is limited.
         */
        @java.lang.SuppressWarnings("all")
        public Message getMessage() {
            return this.message;
        }

        /**
         * The set of locations where the result was detected. Specify only one location unless the problem indicated by
         * the result can only be corrected by making a change at every specified location.
         */
        @java.lang.SuppressWarnings("all")
        public List<Location> getLocations() {
            return this.locations;
        }

        /**
         * Key/value pairs that provide additional information about the address.
         */
        @java.lang.SuppressWarnings("all")
        public PropertyBag getProperties() {
            return this.properties;
        }

        /**
         * The stable, unique identifier of the rule, if any, to which this result is relevant.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Result setRuleId(final String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        /**
         * The index link the rule, if any, to which this result is relevant.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Result setRuleIndex(final Integer ruleIndex) {
            this.ruleIndex = ruleIndex;
            return this;
        }

        /**
         * A message that describes the result. The first sentence of the message only will be displayed when visible
         * space is limited.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Result setMessage(final Message message) {
            this.message = message;
            return this;
        }

        /**
         * The set of locations where the result was detected. Specify only one location unless the problem indicated by
         * the result can only be corrected by making a change at every specified location.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Result setLocations(final List<Location> locations) {
            this.locations = locations;
            return this;
        }

        /**
         * Key/value pairs that provide additional information about the address.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Result setProperties(final PropertyBag properties) {
            this.properties = properties;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Result)) {
                return false;
            }
            final SarifLog.Result other = (SarifLog.Result) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$ruleId = this.getRuleId();
            final java.lang.Object other$ruleId = other.getRuleId();
            if (this$ruleId == null ? other$ruleId != null : !this$ruleId.equals(other$ruleId)) {
                return false;
            }
            final java.lang.Object this$ruleIndex = this.getRuleIndex();
            final java.lang.Object other$ruleIndex = other.getRuleIndex();
            if (this$ruleIndex == null ? other$ruleIndex != null : !this$ruleIndex.equals(other$ruleIndex)) {
                return false;
            }
            final java.lang.Object this$message = this.getMessage();
            final java.lang.Object other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            final java.lang.Object this$locations = this.getLocations();
            final java.lang.Object other$locations = other.getLocations();
            if (this$locations == null ? other$locations != null : !this$locations.equals(other$locations)) {
                return false;
            }
            final java.lang.Object this$properties = this.getProperties();
            final java.lang.Object other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $ruleId = this.getRuleId();
            result = result * PRIME + ($ruleId == null ? 43 : $ruleId.hashCode());
            final java.lang.Object $ruleIndex = this.getRuleIndex();
            result = result * PRIME + ($ruleIndex == null ? 43 : $ruleIndex.hashCode());
            final java.lang.Object $message = this.getMessage();
            result = result * PRIME + ($message == null ? 43 : $message.hashCode());
            final java.lang.Object $locations = this.getLocations();
            result = result * PRIME + ($locations == null ? 43 : $locations.hashCode());
            final java.lang.Object $properties = this.getProperties();
            result = result * PRIME + ($properties == null ? 43 : $properties.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Result(ruleId=" + this.getRuleId() + ", ruleIndex=" + this.getRuleIndex() + ", message=" + this.getMessage() + ", locations=" + this.getLocations() + ", properties=" + this.getProperties() + ")";
        }
    }


    /**
     * Encapsulates a message intended to be read by the end user.
     */
    public static class Message {
        /**
         * A plain text message string.
         */
        private String text;
        /**
         * A Markdown message string.
         */
        private String markdown;
        /**
         * The identifier for this message.
         */
        private String id;

        @java.lang.SuppressWarnings("all")
        Message(final String text, final String markdown, final String id) {
            this.text = text;
            this.markdown = markdown;
            this.id = id;
        }


        @java.lang.SuppressWarnings("all")
        public static class MessageBuilder {
            @java.lang.SuppressWarnings("all")
            private String text;
            @java.lang.SuppressWarnings("all")
            private String markdown;
            @java.lang.SuppressWarnings("all")
            private String id;

            @java.lang.SuppressWarnings("all")
            MessageBuilder() {
            }

            /**
             * A plain text message string.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Message.MessageBuilder text(final String text) {
                this.text = text;
                return this;
            }

            /**
             * A Markdown message string.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Message.MessageBuilder markdown(final String markdown) {
                this.markdown = markdown;
                return this;
            }

            /**
             * The identifier for this message.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Message.MessageBuilder id(final String id) {
                this.id = id;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Message build() {
                return new SarifLog.Message(this.text, this.markdown, this.id);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Message.MessageBuilder(text=" + this.text + ", markdown=" + this.markdown + ", id=" + this.id + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Message.MessageBuilder builder() {
            return new SarifLog.Message.MessageBuilder();
        }

        /**
         * A plain text message string.
         */
        @java.lang.SuppressWarnings("all")
        public String getText() {
            return this.text;
        }

        /**
         * A Markdown message string.
         */
        @java.lang.SuppressWarnings("all")
        public String getMarkdown() {
            return this.markdown;
        }

        /**
         * The identifier for this message.
         */
        @java.lang.SuppressWarnings("all")
        public String getId() {
            return this.id;
        }

        /**
         * A plain text message string.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Message setText(final String text) {
            this.text = text;
            return this;
        }

        /**
         * A Markdown message string.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Message setMarkdown(final String markdown) {
            this.markdown = markdown;
            return this;
        }

        /**
         * The identifier for this message.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Message setId(final String id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Message)) {
                return false;
            }
            final SarifLog.Message other = (SarifLog.Message) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$text = this.getText();
            final java.lang.Object other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            final java.lang.Object this$markdown = this.getMarkdown();
            final java.lang.Object other$markdown = other.getMarkdown();
            if (this$markdown == null ? other$markdown != null : !this$markdown.equals(other$markdown)) {
                return false;
            }
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Message;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $text = this.getText();
            result = result * PRIME + ($text == null ? 43 : $text.hashCode());
            final java.lang.Object $markdown = this.getMarkdown();
            result = result * PRIME + ($markdown == null ? 43 : $markdown.hashCode());
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Message(text=" + this.getText() + ", markdown=" + this.getMarkdown() + ", id=" + this.getId() + ")";
        }
    }


    /**
     * Describes a single run of an analysis tool, and contains the reported output of that run.
     */
    public static class Run {
        /**
         * Information about the tool or tool pipeline that generated the results in this run. A run can only contain
         * results produced by a single tool or tool pipeline. A run can aggregate results from multiple log files, as long
         * as context around the tool run (tool command-line arguments and the like) is identical for all aggregated files.
         */
        private Tool tool;
        /**
         * The set of results contained in an SARIF log. The results array can be omitted when a run is solely exporting
         * rules metadata. It must be present (but may be empty) if a log file represents an actual scan.
         */
        private List<Result> results;
        /**
         * The set of invocations providing information about the tool execution such as configuration errors or runtime
         * exceptions
         */
        private List<Invocation> invocations;

        @java.lang.SuppressWarnings("all")
        Run(final Tool tool, final List<Result> results, final List<Invocation> invocations) {
            this.tool = tool;
            this.results = results;
            this.invocations = invocations;
        }


        @java.lang.SuppressWarnings("all")
        public static class RunBuilder {
            @java.lang.SuppressWarnings("all")
            private Tool tool;
            @java.lang.SuppressWarnings("all")
            private java.util.ArrayList<Result> results;
            @java.lang.SuppressWarnings("all")
            private List<Invocation> invocations;

            @java.lang.SuppressWarnings("all")
            RunBuilder() {
            }

            /**
             * Information about the tool or tool pipeline that generated the results in this run. A run can only contain
             * results produced by a single tool or tool pipeline. A run can aggregate results from multiple log files, as long
             * as context around the tool run (tool command-line arguments and the like) is identical for all aggregated files.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Run.RunBuilder tool(final Tool tool) {
                this.tool = tool;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Run.RunBuilder result(final Result result) {
                if (this.results == null) {
                    this.results = new java.util.ArrayList<Result>();
                }
                this.results.add(result);
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Run.RunBuilder results(final java.util.Collection<? extends Result> results) {
                if (results == null) {
                    throw new java.lang.NullPointerException("results cannot be null");
                }
                if (this.results == null) {
                    this.results = new java.util.ArrayList<Result>();
                }
                this.results.addAll(results);
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Run.RunBuilder clearResults() {
                if (this.results != null) {
                    this.results.clear();
                }
                return this;
            }

            /**
             * The set of invocations providing information about the tool execution such as configuration errors or runtime
             * exceptions
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Run.RunBuilder invocations(final List<Invocation> invocations) {
                this.invocations = invocations;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Run build() {
                java.util.List<Result> results;
                switch (this.results == null ? 0 : this.results.size()) {
                case 0:
                    results = java.util.Collections.emptyList();
                    break;
                case 1:
                    results = java.util.Collections.singletonList(this.results.get(0));
                    break;
                default:
                    results = java.util.Collections.unmodifiableList(new java.util.ArrayList<Result>(this.results));
                }
                return new SarifLog.Run(this.tool, results, this.invocations);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Run.RunBuilder(tool=" + this.tool + ", results=" + this.results + ", invocations=" + this.invocations + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Run.RunBuilder builder() {
            return new SarifLog.Run.RunBuilder();
        }

        /**
         * Information about the tool or tool pipeline that generated the results in this run. A run can only contain
         * results produced by a single tool or tool pipeline. A run can aggregate results from multiple log files, as long
         * as context around the tool run (tool command-line arguments and the like) is identical for all aggregated files.
         */
        @java.lang.SuppressWarnings("all")
        public Tool getTool() {
            return this.tool;
        }

        /**
         * The set of results contained in an SARIF log. The results array can be omitted when a run is solely exporting
         * rules metadata. It must be present (but may be empty) if a log file represents an actual scan.
         */
        @java.lang.SuppressWarnings("all")
        public List<Result> getResults() {
            return this.results;
        }

        /**
         * The set of invocations providing information about the tool execution such as configuration errors or runtime
         * exceptions
         */
        @java.lang.SuppressWarnings("all")
        public List<Invocation> getInvocations() {
            return this.invocations;
        }

        /**
         * Information about the tool or tool pipeline that generated the results in this run. A run can only contain
         * results produced by a single tool or tool pipeline. A run can aggregate results from multiple log files, as long
         * as context around the tool run (tool command-line arguments and the like) is identical for all aggregated files.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Run setTool(final Tool tool) {
            this.tool = tool;
            return this;
        }

        /**
         * The set of results contained in an SARIF log. The results array can be omitted when a run is solely exporting
         * rules metadata. It must be present (but may be empty) if a log file represents an actual scan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Run setResults(final List<Result> results) {
            this.results = results;
            return this;
        }

        /**
         * The set of invocations providing information about the tool execution such as configuration errors or runtime
         * exceptions
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Run setInvocations(final List<Invocation> invocations) {
            this.invocations = invocations;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Run)) {
                return false;
            }
            final SarifLog.Run other = (SarifLog.Run) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$tool = this.getTool();
            final java.lang.Object other$tool = other.getTool();
            if (this$tool == null ? other$tool != null : !this$tool.equals(other$tool)) {
                return false;
            }
            final java.lang.Object this$results = this.getResults();
            final java.lang.Object other$results = other.getResults();
            if (this$results == null ? other$results != null : !this$results.equals(other$results)) {
                return false;
            }
            final java.lang.Object this$invocations = this.getInvocations();
            final java.lang.Object other$invocations = other.getInvocations();
            if (this$invocations == null ? other$invocations != null : !this$invocations.equals(other$invocations)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Run;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $tool = this.getTool();
            result = result * PRIME + ($tool == null ? 43 : $tool.hashCode());
            final java.lang.Object $results = this.getResults();
            result = result * PRIME + ($results == null ? 43 : $results.hashCode());
            final java.lang.Object $invocations = this.getInvocations();
            result = result * PRIME + ($invocations == null ? 43 : $invocations.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Run(tool=" + this.getTool() + ", results=" + this.getResults() + ", invocations=" + this.getInvocations() + ")";
        }
    }


    /**
     * The analysis tool that was run.
     */
    public static class Tool {
        /**
         * The analysis tool that was run.
         */
        private Component driver;

        @java.lang.SuppressWarnings("all")
        Tool(final Component driver) {
            this.driver = driver;
        }


        @java.lang.SuppressWarnings("all")
        public static class ToolBuilder {
            @java.lang.SuppressWarnings("all")
            private Component driver;

            @java.lang.SuppressWarnings("all")
            ToolBuilder() {
            }

            /**
             * The analysis tool that was run.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Tool.ToolBuilder driver(final Component driver) {
                this.driver = driver;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Tool build() {
                return new SarifLog.Tool(this.driver);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Tool.ToolBuilder(driver=" + this.driver + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Tool.ToolBuilder builder() {
            return new SarifLog.Tool.ToolBuilder();
        }

        /**
         * The analysis tool that was run.
         */
        @java.lang.SuppressWarnings("all")
        public Component getDriver() {
            return this.driver;
        }

        /**
         * The analysis tool that was run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Tool setDriver(final Component driver) {
            this.driver = driver;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Tool)) {
                return false;
            }
            final SarifLog.Tool other = (SarifLog.Tool) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$driver = this.getDriver();
            final java.lang.Object other$driver = other.getDriver();
            if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Tool;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $driver = this.getDriver();
            result = result * PRIME + ($driver == null ? 43 : $driver.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Tool(driver=" + this.getDriver() + ")";
        }
    }


    /**
     * A component, such as a plug-in or the driver, of the analysis tool that was run.
     */
    public static class Component {
        /**
         * The name of the tool component.
         */
        private String name;
        /**
         * The tool component version, in whatever format the component natively provides.
         */
        private String version;
        /**
         * The absolute URI at which information about this version of the tool component can be found.
         */
        private String informationUri;
        /**
         * An array of reportingDescriptor objects relevant to the analysis performed by the tool component.
         */
        private List<ReportingDescriptor> rules;

        @java.lang.SuppressWarnings("all")
        Component(final String name, final String version, final String informationUri, final List<ReportingDescriptor> rules) {
            this.name = name;
            this.version = version;
            this.informationUri = informationUri;
            this.rules = rules;
        }


        @java.lang.SuppressWarnings("all")
        public static class ComponentBuilder {
            @java.lang.SuppressWarnings("all")
            private String name;
            @java.lang.SuppressWarnings("all")
            private String version;
            @java.lang.SuppressWarnings("all")
            private String informationUri;
            @java.lang.SuppressWarnings("all")
            private List<ReportingDescriptor> rules;

            @java.lang.SuppressWarnings("all")
            ComponentBuilder() {
            }

            /**
             * The name of the tool component.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Component.ComponentBuilder name(final String name) {
                this.name = name;
                return this;
            }

            /**
             * The tool component version, in whatever format the component natively provides.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Component.ComponentBuilder version(final String version) {
                this.version = version;
                return this;
            }

            /**
             * The absolute URI at which information about this version of the tool component can be found.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Component.ComponentBuilder informationUri(final String informationUri) {
                this.informationUri = informationUri;
                return this;
            }

            /**
             * An array of reportingDescriptor objects relevant to the analysis performed by the tool component.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Component.ComponentBuilder rules(final List<ReportingDescriptor> rules) {
                this.rules = rules;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Component build() {
                return new SarifLog.Component(this.name, this.version, this.informationUri, this.rules);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Component.ComponentBuilder(name=" + this.name + ", version=" + this.version + ", informationUri=" + this.informationUri + ", rules=" + this.rules + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Component.ComponentBuilder builder() {
            return new SarifLog.Component.ComponentBuilder();
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.Component.ComponentBuilder toBuilder() {
            return new SarifLog.Component.ComponentBuilder().name(this.name).version(this.version).informationUri(this.informationUri).rules(this.rules);
        }

        /**
         * The name of the tool component.
         */
        @java.lang.SuppressWarnings("all")
        public String getName() {
            return this.name;
        }

        /**
         * The tool component version, in whatever format the component natively provides.
         */
        @java.lang.SuppressWarnings("all")
        public String getVersion() {
            return this.version;
        }

        /**
         * The absolute URI at which information about this version of the tool component can be found.
         */
        @java.lang.SuppressWarnings("all")
        public String getInformationUri() {
            return this.informationUri;
        }

        /**
         * An array of reportingDescriptor objects relevant to the analysis performed by the tool component.
         */
        @java.lang.SuppressWarnings("all")
        public List<ReportingDescriptor> getRules() {
            return this.rules;
        }

        /**
         * The name of the tool component.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Component setName(final String name) {
            this.name = name;
            return this;
        }

        /**
         * The tool component version, in whatever format the component natively provides.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Component setVersion(final String version) {
            this.version = version;
            return this;
        }

        /**
         * The absolute URI at which information about this version of the tool component can be found.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Component setInformationUri(final String informationUri) {
            this.informationUri = informationUri;
            return this;
        }

        /**
         * An array of reportingDescriptor objects relevant to the analysis performed by the tool component.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Component setRules(final List<ReportingDescriptor> rules) {
            this.rules = rules;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Component)) {
                return false;
            }
            final SarifLog.Component other = (SarifLog.Component) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            final java.lang.Object this$version = this.getVersion();
            final java.lang.Object other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            final java.lang.Object this$informationUri = this.getInformationUri();
            final java.lang.Object other$informationUri = other.getInformationUri();
            if (this$informationUri == null ? other$informationUri != null : !this$informationUri.equals(other$informationUri)) {
                return false;
            }
            final java.lang.Object this$rules = this.getRules();
            final java.lang.Object other$rules = other.getRules();
            if (this$rules == null ? other$rules != null : !this$rules.equals(other$rules)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Component;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $version = this.getVersion();
            result = result * PRIME + ($version == null ? 43 : $version.hashCode());
            final java.lang.Object $informationUri = this.getInformationUri();
            result = result * PRIME + ($informationUri == null ? 43 : $informationUri.hashCode());
            final java.lang.Object $rules = this.getRules();
            result = result * PRIME + ($rules == null ? 43 : $rules.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Component(name=" + this.getName() + ", version=" + this.getVersion() + ", informationUri=" + this.getInformationUri() + ", rules=" + this.getRules() + ")";
        }
    }


    /**
     * Metadata that describes a specific report produced by the tool, as part of the analysis it provides or its runtime
     * reporting.
     */
    public static class ReportingDescriptor {
        /**
         * A stable, opaque identifier for the report.
         */
        private String id;
        /**
         * A report identifier that is understandable to an end user.
         */
        private String name;
        /**
         * A concise description of the report. Should be a single sentence that is understandable when visible space is
         * limited to a single line of text.
         */
        private MultiformatMessage shortDescription;
        /**
         * A description of the report. Should, as far as possible, provide details sufficient to enable resolution of any
         * problem indicated by the result.
         */
        private MultiformatMessage fullDescription;
        /**
         * A set of name/value pairs with arbitrary names. Each value is a multiformatMessageString object, which holds
         * message strings in plain text and (optionally) Markdown format. The strings can include placeholders, which can
         * be used to construct a message in combination with an arbitrary number of additional string arguments.
         */
        private MultiformatMessage messageStrings;
        /**
         * A URI where the primary documentation for the report can be found.
         */
        private String helpUri;
        /**
         * Provides the primary documentation for the report, useful when there is no online documentation.
         */
        private MultiformatMessage help;
        /**
         * Key/value pairs that provide additional information about the report.
         */
        private PropertyBag properties;

        @java.lang.SuppressWarnings("all")
        ReportingDescriptor(final String id, final String name, final MultiformatMessage shortDescription, final MultiformatMessage fullDescription, final MultiformatMessage messageStrings, final String helpUri, final MultiformatMessage help, final PropertyBag properties) {
            this.id = id;
            this.name = name;
            this.shortDescription = shortDescription;
            this.fullDescription = fullDescription;
            this.messageStrings = messageStrings;
            this.helpUri = helpUri;
            this.help = help;
            this.properties = properties;
        }


        @java.lang.SuppressWarnings("all")
        public static class ReportingDescriptorBuilder {
            @java.lang.SuppressWarnings("all")
            private String id;
            @java.lang.SuppressWarnings("all")
            private String name;
            @java.lang.SuppressWarnings("all")
            private MultiformatMessage shortDescription;
            @java.lang.SuppressWarnings("all")
            private MultiformatMessage fullDescription;
            @java.lang.SuppressWarnings("all")
            private MultiformatMessage messageStrings;
            @java.lang.SuppressWarnings("all")
            private String helpUri;
            @java.lang.SuppressWarnings("all")
            private MultiformatMessage help;
            @java.lang.SuppressWarnings("all")
            private PropertyBag properties;

            @java.lang.SuppressWarnings("all")
            ReportingDescriptorBuilder() {
            }

            /**
             * A stable, opaque identifier for the report.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor.ReportingDescriptorBuilder id(final String id) {
                this.id = id;
                return this;
            }

            /**
             * A report identifier that is understandable to an end user.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor.ReportingDescriptorBuilder name(final String name) {
                this.name = name;
                return this;
            }

            /**
             * A concise description of the report. Should be a single sentence that is understandable when visible space is
             * limited to a single line of text.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor.ReportingDescriptorBuilder shortDescription(final MultiformatMessage shortDescription) {
                this.shortDescription = shortDescription;
                return this;
            }

            /**
             * A description of the report. Should, as far as possible, provide details sufficient to enable resolution of any
             * problem indicated by the result.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor.ReportingDescriptorBuilder fullDescription(final MultiformatMessage fullDescription) {
                this.fullDescription = fullDescription;
                return this;
            }

            /**
             * A set of name/value pairs with arbitrary names. Each value is a multiformatMessageString object, which holds
             * message strings in plain text and (optionally) Markdown format. The strings can include placeholders, which can
             * be used to construct a message in combination with an arbitrary number of additional string arguments.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor.ReportingDescriptorBuilder messageStrings(final MultiformatMessage messageStrings) {
                this.messageStrings = messageStrings;
                return this;
            }

            /**
             * A URI where the primary documentation for the report can be found.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor.ReportingDescriptorBuilder helpUri(final String helpUri) {
                this.helpUri = helpUri;
                return this;
            }

            /**
             * Provides the primary documentation for the report, useful when there is no online documentation.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor.ReportingDescriptorBuilder help(final MultiformatMessage help) {
                this.help = help;
                return this;
            }

            /**
             * Key/value pairs that provide additional information about the report.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor.ReportingDescriptorBuilder properties(final PropertyBag properties) {
                this.properties = properties;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.ReportingDescriptor build() {
                return new SarifLog.ReportingDescriptor(this.id, this.name, this.shortDescription, this.fullDescription, this.messageStrings, this.helpUri, this.help, this.properties);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.ReportingDescriptor.ReportingDescriptorBuilder(id=" + this.id + ", name=" + this.name + ", shortDescription=" + this.shortDescription + ", fullDescription=" + this.fullDescription + ", messageStrings=" + this.messageStrings + ", helpUri=" + this.helpUri + ", help=" + this.help + ", properties=" + this.properties + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.ReportingDescriptor.ReportingDescriptorBuilder builder() {
            return new SarifLog.ReportingDescriptor.ReportingDescriptorBuilder();
        }

        /**
         * A stable, opaque identifier for the report.
         */
        @java.lang.SuppressWarnings("all")
        public String getId() {
            return this.id;
        }

        /**
         * A report identifier that is understandable to an end user.
         */
        @java.lang.SuppressWarnings("all")
        public String getName() {
            return this.name;
        }

        /**
         * A concise description of the report. Should be a single sentence that is understandable when visible space is
         * limited to a single line of text.
         */
        @java.lang.SuppressWarnings("all")
        public MultiformatMessage getShortDescription() {
            return this.shortDescription;
        }

        /**
         * A description of the report. Should, as far as possible, provide details sufficient to enable resolution of any
         * problem indicated by the result.
         */
        @java.lang.SuppressWarnings("all")
        public MultiformatMessage getFullDescription() {
            return this.fullDescription;
        }

        /**
         * A set of name/value pairs with arbitrary names. Each value is a multiformatMessageString object, which holds
         * message strings in plain text and (optionally) Markdown format. The strings can include placeholders, which can
         * be used to construct a message in combination with an arbitrary number of additional string arguments.
         */
        @java.lang.SuppressWarnings("all")
        public MultiformatMessage getMessageStrings() {
            return this.messageStrings;
        }

        /**
         * A URI where the primary documentation for the report can be found.
         */
        @java.lang.SuppressWarnings("all")
        public String getHelpUri() {
            return this.helpUri;
        }

        /**
         * Provides the primary documentation for the report, useful when there is no online documentation.
         */
        @java.lang.SuppressWarnings("all")
        public MultiformatMessage getHelp() {
            return this.help;
        }

        /**
         * Key/value pairs that provide additional information about the report.
         */
        @java.lang.SuppressWarnings("all")
        public PropertyBag getProperties() {
            return this.properties;
        }

        /**
         * A stable, opaque identifier for the report.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ReportingDescriptor setId(final String id) {
            this.id = id;
            return this;
        }

        /**
         * A report identifier that is understandable to an end user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ReportingDescriptor setName(final String name) {
            this.name = name;
            return this;
        }

        /**
         * A concise description of the report. Should be a single sentence that is understandable when visible space is
         * limited to a single line of text.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ReportingDescriptor setShortDescription(final MultiformatMessage shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        /**
         * A description of the report. Should, as far as possible, provide details sufficient to enable resolution of any
         * problem indicated by the result.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ReportingDescriptor setFullDescription(final MultiformatMessage fullDescription) {
            this.fullDescription = fullDescription;
            return this;
        }

        /**
         * A set of name/value pairs with arbitrary names. Each value is a multiformatMessageString object, which holds
         * message strings in plain text and (optionally) Markdown format. The strings can include placeholders, which can
         * be used to construct a message in combination with an arbitrary number of additional string arguments.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ReportingDescriptor setMessageStrings(final MultiformatMessage messageStrings) {
            this.messageStrings = messageStrings;
            return this;
        }

        /**
         * A URI where the primary documentation for the report can be found.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ReportingDescriptor setHelpUri(final String helpUri) {
            this.helpUri = helpUri;
            return this;
        }

        /**
         * Provides the primary documentation for the report, useful when there is no online documentation.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ReportingDescriptor setHelp(final MultiformatMessage help) {
            this.help = help;
            return this;
        }

        /**
         * Key/value pairs that provide additional information about the report.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ReportingDescriptor setProperties(final PropertyBag properties) {
            this.properties = properties;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.ReportingDescriptor)) {
                return false;
            }
            final SarifLog.ReportingDescriptor other = (SarifLog.ReportingDescriptor) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            final java.lang.Object this$shortDescription = this.getShortDescription();
            final java.lang.Object other$shortDescription = other.getShortDescription();
            if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
                return false;
            }
            final java.lang.Object this$fullDescription = this.getFullDescription();
            final java.lang.Object other$fullDescription = other.getFullDescription();
            if (this$fullDescription == null ? other$fullDescription != null : !this$fullDescription.equals(other$fullDescription)) {
                return false;
            }
            final java.lang.Object this$messageStrings = this.getMessageStrings();
            final java.lang.Object other$messageStrings = other.getMessageStrings();
            if (this$messageStrings == null ? other$messageStrings != null : !this$messageStrings.equals(other$messageStrings)) {
                return false;
            }
            final java.lang.Object this$helpUri = this.getHelpUri();
            final java.lang.Object other$helpUri = other.getHelpUri();
            if (this$helpUri == null ? other$helpUri != null : !this$helpUri.equals(other$helpUri)) {
                return false;
            }
            final java.lang.Object this$help = this.getHelp();
            final java.lang.Object other$help = other.getHelp();
            if (this$help == null ? other$help != null : !this$help.equals(other$help)) {
                return false;
            }
            final java.lang.Object this$properties = this.getProperties();
            final java.lang.Object other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.ReportingDescriptor;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $shortDescription = this.getShortDescription();
            result = result * PRIME + ($shortDescription == null ? 43 : $shortDescription.hashCode());
            final java.lang.Object $fullDescription = this.getFullDescription();
            result = result * PRIME + ($fullDescription == null ? 43 : $fullDescription.hashCode());
            final java.lang.Object $messageStrings = this.getMessageStrings();
            result = result * PRIME + ($messageStrings == null ? 43 : $messageStrings.hashCode());
            final java.lang.Object $helpUri = this.getHelpUri();
            result = result * PRIME + ($helpUri == null ? 43 : $helpUri.hashCode());
            final java.lang.Object $help = this.getHelp();
            result = result * PRIME + ($help == null ? 43 : $help.hashCode());
            final java.lang.Object $properties = this.getProperties();
            result = result * PRIME + ($properties == null ? 43 : $properties.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.ReportingDescriptor(id=" + this.getId() + ", name=" + this.getName() + ", shortDescription=" + this.getShortDescription() + ", fullDescription=" + this.getFullDescription() + ", messageStrings=" + this.getMessageStrings() + ", helpUri=" + this.getHelpUri() + ", help=" + this.getHelp() + ", properties=" + this.getProperties() + ")";
        }
    }


    /**
     * A message string or message format string rendered in multiple formats.
     */
    public static class MultiformatMessage {
        /**
         * A plain text message string or format string.
         */
        private String text;
        /**
         * A Markdown message string or format string.
         */
        private String markdown;

        public MultiformatMessage(String text) {
            this.text = text;
        }


        @java.lang.SuppressWarnings("all")
        public static class MultiformatMessageBuilder {
            @java.lang.SuppressWarnings("all")
            private String text;
            @java.lang.SuppressWarnings("all")
            private String markdown;

            @java.lang.SuppressWarnings("all")
            MultiformatMessageBuilder() {
            }

            /**
             * A plain text message string or format string.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.MultiformatMessage.MultiformatMessageBuilder text(final String text) {
                this.text = text;
                return this;
            }

            /**
             * A Markdown message string or format string.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.MultiformatMessage.MultiformatMessageBuilder markdown(final String markdown) {
                this.markdown = markdown;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.MultiformatMessage build() {
                return new SarifLog.MultiformatMessage(this.text, this.markdown);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.MultiformatMessage.MultiformatMessageBuilder(text=" + this.text + ", markdown=" + this.markdown + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.MultiformatMessage.MultiformatMessageBuilder builder() {
            return new SarifLog.MultiformatMessage.MultiformatMessageBuilder();
        }

        /**
         * A plain text message string or format string.
         */
        @java.lang.SuppressWarnings("all")
        public String getText() {
            return this.text;
        }

        /**
         * A Markdown message string or format string.
         */
        @java.lang.SuppressWarnings("all")
        public String getMarkdown() {
            return this.markdown;
        }

        /**
         * A plain text message string or format string.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.MultiformatMessage setText(final String text) {
            this.text = text;
            return this;
        }

        /**
         * A Markdown message string or format string.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.MultiformatMessage setMarkdown(final String markdown) {
            this.markdown = markdown;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.MultiformatMessage)) {
                return false;
            }
            final SarifLog.MultiformatMessage other = (SarifLog.MultiformatMessage) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$text = this.getText();
            final java.lang.Object other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            final java.lang.Object this$markdown = this.getMarkdown();
            final java.lang.Object other$markdown = other.getMarkdown();
            if (this$markdown == null ? other$markdown != null : !this$markdown.equals(other$markdown)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.MultiformatMessage;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $text = this.getText();
            result = result * PRIME + ($text == null ? 43 : $text.hashCode());
            final java.lang.Object $markdown = this.getMarkdown();
            result = result * PRIME + ($markdown == null ? 43 : $markdown.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.MultiformatMessage(text=" + this.getText() + ", markdown=" + this.getMarkdown() + ")";
        }

        @java.lang.SuppressWarnings("all")
        public MultiformatMessage() {
        }

        @java.lang.SuppressWarnings("all")
        public MultiformatMessage(final String text, final String markdown) {
            this.text = text;
            this.markdown = markdown;
        }
    }


    /**
     * A exception information object, for the tool runtime errors.
     */
    public static class Exception {
        /**
         * A plain text message string or format string.
         */
        private String message;

        @java.lang.SuppressWarnings("all")
        Exception(final String message) {
            this.message = message;
        }


        @java.lang.SuppressWarnings("all")
        public static class ExceptionBuilder {
            @java.lang.SuppressWarnings("all")
            private String message;

            @java.lang.SuppressWarnings("all")
            ExceptionBuilder() {
            }

            /**
             * A plain text message string or format string.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.Exception.ExceptionBuilder message(final String message) {
                this.message = message;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Exception build() {
                return new SarifLog.Exception(this.message);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Exception.ExceptionBuilder(message=" + this.message + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Exception.ExceptionBuilder builder() {
            return new SarifLog.Exception.ExceptionBuilder();
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.Exception.ExceptionBuilder toBuilder() {
            return new SarifLog.Exception.ExceptionBuilder().message(this.message);
        }

        /**
         * A plain text message string or format string.
         */
        @java.lang.SuppressWarnings("all")
        public String getMessage() {
            return this.message;
        }

        /**
         * A plain text message string or format string.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.Exception setMessage(final String message) {
            this.message = message;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Exception)) {
                return false;
            }
            final SarifLog.Exception other = (SarifLog.Exception) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$message = this.getMessage();
            final java.lang.Object other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Exception;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $message = this.getMessage();
            result = result * PRIME + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Exception(message=" + this.getMessage() + ")";
        }
    }


    /**
     * A associated rule to the toolConfigurationNotification.
     */
    public static class AssociatedRule {
        /**
         * The stable, unique identifier of the rule, if any, to which this result is relevant.
         */
        private String id;

        @java.lang.SuppressWarnings("all")
        AssociatedRule(final String id) {
            this.id = id;
        }


        @java.lang.SuppressWarnings("all")
        public static class AssociatedRuleBuilder {
            @java.lang.SuppressWarnings("all")
            private String id;

            @java.lang.SuppressWarnings("all")
            AssociatedRuleBuilder() {
            }

            /**
             * The stable, unique identifier of the rule, if any, to which this result is relevant.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.AssociatedRule.AssociatedRuleBuilder id(final String id) {
                this.id = id;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.AssociatedRule build() {
                return new SarifLog.AssociatedRule(this.id);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.AssociatedRule.AssociatedRuleBuilder(id=" + this.id + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.AssociatedRule.AssociatedRuleBuilder builder() {
            return new SarifLog.AssociatedRule.AssociatedRuleBuilder();
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.AssociatedRule.AssociatedRuleBuilder toBuilder() {
            return new SarifLog.AssociatedRule.AssociatedRuleBuilder().id(this.id);
        }

        /**
         * The stable, unique identifier of the rule, if any, to which this result is relevant.
         */
        @java.lang.SuppressWarnings("all")
        public String getId() {
            return this.id;
        }

        /**
         * The stable, unique identifier of the rule, if any, to which this result is relevant.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.AssociatedRule setId(final String id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.AssociatedRule)) {
                return false;
            }
            final SarifLog.AssociatedRule other = (SarifLog.AssociatedRule) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.AssociatedRule;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.AssociatedRule(id=" + this.getId() + ")";
        }
    }


    /**
     * An invocation property to specify tool configuration errors.
     */
    public static class ToolConfigurationNotification {
        /**
         * An associated rule
         */
        private AssociatedRule associatedRule;
        /**
         * A message component to detail the configuration error
         */
        private Message message;

        @java.lang.SuppressWarnings("all")
        ToolConfigurationNotification(final AssociatedRule associatedRule, final Message message) {
            this.associatedRule = associatedRule;
            this.message = message;
        }


        @java.lang.SuppressWarnings("all")
        public static class ToolConfigurationNotificationBuilder {
            @java.lang.SuppressWarnings("all")
            private AssociatedRule associatedRule;
            @java.lang.SuppressWarnings("all")
            private Message message;

            @java.lang.SuppressWarnings("all")
            ToolConfigurationNotificationBuilder() {
            }

            /**
             * An associated rule
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder associatedRule(final AssociatedRule associatedRule) {
                this.associatedRule = associatedRule;
                return this;
            }

            /**
             * A message component to detail the configuration error
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder message(final Message message) {
                this.message = message;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.ToolConfigurationNotification build() {
                return new SarifLog.ToolConfigurationNotification(this.associatedRule, this.message);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder(associatedRule=" + this.associatedRule + ", message=" + this.message + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder builder() {
            return new SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder();
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder toBuilder() {
            return new SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder().associatedRule(this.associatedRule).message(this.message);
        }

        /**
         * An associated rule
         */
        @java.lang.SuppressWarnings("all")
        public AssociatedRule getAssociatedRule() {
            return this.associatedRule;
        }

        /**
         * A message component to detail the configuration error
         */
        @java.lang.SuppressWarnings("all")
        public Message getMessage() {
            return this.message;
        }

        /**
         * An associated rule
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ToolConfigurationNotification setAssociatedRule(final AssociatedRule associatedRule) {
            this.associatedRule = associatedRule;
            return this;
        }

        /**
         * A message component to detail the configuration error
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ToolConfigurationNotification setMessage(final Message message) {
            this.message = message;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.ToolConfigurationNotification)) {
                return false;
            }
            final SarifLog.ToolConfigurationNotification other = (SarifLog.ToolConfigurationNotification) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$associatedRule = this.getAssociatedRule();
            final java.lang.Object other$associatedRule = other.getAssociatedRule();
            if (this$associatedRule == null ? other$associatedRule != null : !this$associatedRule.equals(other$associatedRule)) {
                return false;
            }
            final java.lang.Object this$message = this.getMessage();
            final java.lang.Object other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.ToolConfigurationNotification;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $associatedRule = this.getAssociatedRule();
            result = result * PRIME + ($associatedRule == null ? 43 : $associatedRule.hashCode());
            final java.lang.Object $message = this.getMessage();
            result = result * PRIME + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.ToolConfigurationNotification(associatedRule=" + this.getAssociatedRule() + ", message=" + this.getMessage() + ")";
        }
    }


    /**
     * An invocation property to specify tool runtime errors.
     */
    public static class ToolExecutionNotification {
        /**
         * A list of related locations to the error
         */
        private List<Location> locations;
        /**
         * A message component to detail the runtime error
         */
        private Message message;
        /**
         * A exception component to detail the tool exception
         */
        private Exception exception;

        @java.lang.SuppressWarnings("all")
        ToolExecutionNotification(final List<Location> locations, final Message message, final Exception exception) {
            this.locations = locations;
            this.message = message;
            this.exception = exception;
        }


        @java.lang.SuppressWarnings("all")
        public static class ToolExecutionNotificationBuilder {
            @java.lang.SuppressWarnings("all")
            private List<Location> locations;
            @java.lang.SuppressWarnings("all")
            private Message message;
            @java.lang.SuppressWarnings("all")
            private Exception exception;

            @java.lang.SuppressWarnings("all")
            ToolExecutionNotificationBuilder() {
            }

            /**
             * A list of related locations to the error
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder locations(final List<Location> locations) {
                this.locations = locations;
                return this;
            }

            /**
             * A message component to detail the runtime error
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder message(final Message message) {
                this.message = message;
                return this;
            }

            /**
             * A exception component to detail the tool exception
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            public SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder exception(final Exception exception) {
                this.exception = exception;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.ToolExecutionNotification build() {
                return new SarifLog.ToolExecutionNotification(this.locations, this.message, this.exception);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder(locations=" + this.locations + ", message=" + this.message + ", exception=" + this.exception + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder builder() {
            return new SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder();
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder toBuilder() {
            return new SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder().locations(this.locations).message(this.message).exception(this.exception);
        }

        /**
         * A list of related locations to the error
         */
        @java.lang.SuppressWarnings("all")
        public List<Location> getLocations() {
            return this.locations;
        }

        /**
         * A message component to detail the runtime error
         */
        @java.lang.SuppressWarnings("all")
        public Message getMessage() {
            return this.message;
        }

        /**
         * A exception component to detail the tool exception
         */
        @java.lang.SuppressWarnings("all")
        public Exception getException() {
            return this.exception;
        }

        /**
         * A list of related locations to the error
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ToolExecutionNotification setLocations(final List<Location> locations) {
            this.locations = locations;
            return this;
        }

        /**
         * A message component to detail the runtime error
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ToolExecutionNotification setMessage(final Message message) {
            this.message = message;
            return this;
        }

        /**
         * A exception component to detail the tool exception
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.ToolExecutionNotification setException(final Exception exception) {
            this.exception = exception;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.ToolExecutionNotification)) {
                return false;
            }
            final SarifLog.ToolExecutionNotification other = (SarifLog.ToolExecutionNotification) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$locations = this.getLocations();
            final java.lang.Object other$locations = other.getLocations();
            if (this$locations == null ? other$locations != null : !this$locations.equals(other$locations)) {
                return false;
            }
            final java.lang.Object this$message = this.getMessage();
            final java.lang.Object other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            final java.lang.Object this$exception = this.getException();
            final java.lang.Object other$exception = other.getException();
            if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.ToolExecutionNotification;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $locations = this.getLocations();
            result = result * PRIME + ($locations == null ? 43 : $locations.hashCode());
            final java.lang.Object $message = this.getMessage();
            result = result * PRIME + ($message == null ? 43 : $message.hashCode());
            final java.lang.Object $exception = this.getException();
            result = result * PRIME + ($exception == null ? 43 : $exception.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.ToolExecutionNotification(locations=" + this.getLocations() + ", message=" + this.getMessage() + ", exception=" + this.getException() + ")";
        }
    }


    /**
     * An invocation component to specify tool invocation details/errors.
     */
    public static class Invocation {
        /**
         * An indicator of execution status
         */
        private Boolean executionSuccessful;
        /**
         * A list of associated tool configuration errors
         */
        private List<ToolConfigurationNotification> toolConfigurationNotifications;
        /**
         * A list of associated tool runtime errors
         */
        private List<ToolExecutionNotification> toolExecutionNotifications;

        @java.lang.SuppressWarnings("all")
        Invocation(final Boolean executionSuccessful, final List<ToolConfigurationNotification> toolConfigurationNotifications, final List<ToolExecutionNotification> toolExecutionNotifications) {
            this.executionSuccessful = executionSuccessful;
            this.toolConfigurationNotifications = toolConfigurationNotifications;
            this.toolExecutionNotifications = toolExecutionNotifications;
        }


        @java.lang.SuppressWarnings("all")
        public static class InvocationBuilder {
            @java.lang.SuppressWarnings("all")
            private Boolean executionSuccessful;
            @java.lang.SuppressWarnings("all")
            private List<ToolConfigurationNotification> toolConfigurationNotifications;
            @java.lang.SuppressWarnings("all")
            private List<ToolExecutionNotification> toolExecutionNotifications;

            @java.lang.SuppressWarnings("all")
            InvocationBuilder() {
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Invocation.InvocationBuilder executionSuccessful(final Boolean executionSuccessful) {
                this.executionSuccessful = executionSuccessful;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Invocation.InvocationBuilder toolConfigurationNotifications(final List<ToolConfigurationNotification> toolConfigurationNotifications) {
                this.toolConfigurationNotifications = toolConfigurationNotifications;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Invocation.InvocationBuilder toolExecutionNotifications(final List<ToolExecutionNotification> toolExecutionNotifications) {
                this.toolExecutionNotifications = toolExecutionNotifications;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public SarifLog.Invocation build() {
                return new SarifLog.Invocation(this.executionSuccessful, this.toolConfigurationNotifications, this.toolExecutionNotifications);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            public java.lang.String toString() {
                return "SarifLog.Invocation.InvocationBuilder(executionSuccessful=" + this.executionSuccessful + ", toolConfigurationNotifications=" + this.toolConfigurationNotifications + ", toolExecutionNotifications=" + this.toolExecutionNotifications + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        public static SarifLog.Invocation.InvocationBuilder builder() {
            return new SarifLog.Invocation.InvocationBuilder();
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.Invocation.InvocationBuilder toBuilder() {
            return new SarifLog.Invocation.InvocationBuilder().executionSuccessful(this.executionSuccessful).toolConfigurationNotifications(this.toolConfigurationNotifications).toolExecutionNotifications(this.toolExecutionNotifications);
        }

        @java.lang.SuppressWarnings("all")
        public Boolean getExecutionSuccessful() {
            return this.executionSuccessful;
        }

        @java.lang.SuppressWarnings("all")
        public List<ToolConfigurationNotification> getToolConfigurationNotifications() {
            return this.toolConfigurationNotifications;
        }

        @java.lang.SuppressWarnings("all")
        public List<ToolExecutionNotification> getToolExecutionNotifications() {
            return this.toolExecutionNotifications;
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.Invocation setExecutionSuccessful(final Boolean executionSuccessful) {
            this.executionSuccessful = executionSuccessful;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.Invocation setToolConfigurationNotifications(final List<ToolConfigurationNotification> toolConfigurationNotifications) {
            this.toolConfigurationNotifications = toolConfigurationNotifications;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog.Invocation setToolExecutionNotifications(final List<ToolExecutionNotification> toolExecutionNotifications) {
            this.toolExecutionNotifications = toolExecutionNotifications;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SarifLog.Invocation)) {
                return false;
            }
            final SarifLog.Invocation other = (SarifLog.Invocation) o;
            if (!other.canEqual((java.lang.Object) this)) {
                return false;
            }
            final java.lang.Object this$executionSuccessful = this.getExecutionSuccessful();
            final java.lang.Object other$executionSuccessful = other.getExecutionSuccessful();
            if (this$executionSuccessful == null ? other$executionSuccessful != null : !this$executionSuccessful.equals(other$executionSuccessful)) {
                return false;
            }
            final java.lang.Object this$toolConfigurationNotifications = this.getToolConfigurationNotifications();
            final java.lang.Object other$toolConfigurationNotifications = other.getToolConfigurationNotifications();
            if (this$toolConfigurationNotifications == null ? other$toolConfigurationNotifications != null : !this$toolConfigurationNotifications.equals(other$toolConfigurationNotifications)) {
                return false;
            }
            final java.lang.Object this$toolExecutionNotifications = this.getToolExecutionNotifications();
            final java.lang.Object other$toolExecutionNotifications = other.getToolExecutionNotifications();
            if (this$toolExecutionNotifications == null ? other$toolExecutionNotifications != null : !this$toolExecutionNotifications.equals(other$toolExecutionNotifications)) {
                return false;
            }
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof SarifLog.Invocation;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $executionSuccessful = this.getExecutionSuccessful();
            result = result * PRIME + ($executionSuccessful == null ? 43 : $executionSuccessful.hashCode());
            final java.lang.Object $toolConfigurationNotifications = this.getToolConfigurationNotifications();
            result = result * PRIME + ($toolConfigurationNotifications == null ? 43 : $toolConfigurationNotifications.hashCode());
            final java.lang.Object $toolExecutionNotifications = this.getToolExecutionNotifications();
            result = result * PRIME + ($toolExecutionNotifications == null ? 43 : $toolExecutionNotifications.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.Invocation(executionSuccessful=" + this.getExecutionSuccessful() + ", toolConfigurationNotifications=" + this.getToolConfigurationNotifications() + ", toolExecutionNotifications=" + this.getToolExecutionNotifications() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    private static String defaultSchema() {
        return "https://raw.githubusercontent.com/oasis-tcs/sarif-spec/master/Schemata/sarif-schema-2.1.0.json";
    }

    @java.lang.SuppressWarnings("all")
    private static String defaultVersion() {
        return "2.1.0";
    }

    @java.lang.SuppressWarnings("all")
    SarifLog(final String schema, final String version, final List<Run> runs) {
        this.schema = schema;
        this.version = version;
        this.runs = runs;
    }


    @java.lang.SuppressWarnings("all")
    public static class SarifLogBuilder {
        @java.lang.SuppressWarnings("all")
        private boolean schemaSet;
        @java.lang.SuppressWarnings("all")
        private String schemaValue;
        @java.lang.SuppressWarnings("all")
        private boolean versionSet;
        @java.lang.SuppressWarnings("all")
        private String versionValue;
        @java.lang.SuppressWarnings("all")
        private List<Run> runs;

        @java.lang.SuppressWarnings("all")
        SarifLogBuilder() {
        }

        /**
         * The URI of the JSON schema corresponding to the version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.SarifLogBuilder schema(final String schema) {
            this.schemaValue = schema;
            schemaSet = true;
            return this;
        }

        /**
         * The SARIF format version of this log file.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.SarifLogBuilder version(final String version) {
            this.versionValue = version;
            versionSet = true;
            return this;
        }

        /**
         * The set of runs contained in this log file.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public SarifLog.SarifLogBuilder runs(final List<Run> runs) {
            this.runs = runs;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SarifLog build() {
            String schemaValue = this.schemaValue;
            if (!this.schemaSet) {
                schemaValue = SarifLog.defaultSchema();
            }
            String versionValue = this.versionValue;
            if (!this.versionSet) {
                versionValue = SarifLog.defaultVersion();
            }
            return new SarifLog(schemaValue, versionValue, this.runs);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SarifLog.SarifLogBuilder(schema$value=" + this.schemaValue + ", version$value=" + this.versionValue + ", runs=" + this.runs + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    public static SarifLog.SarifLogBuilder builder() {
        return new SarifLog.SarifLogBuilder();
    }

    /**
     * The URI of the JSON schema corresponding to the version.
     */
    @java.lang.SuppressWarnings("all")
    public String getSchema() {
        return this.schema;
    }

    /**
     * The SARIF format version of this log file.
     */
    @java.lang.SuppressWarnings("all")
    public String getVersion() {
        return this.version;
    }

    /**
     * The set of runs contained in this log file.
     */
    @java.lang.SuppressWarnings("all")
    public List<Run> getRuns() {
        return this.runs;
    }

    /**
     * The URI of the JSON schema corresponding to the version.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public SarifLog setSchema(final String schema) {
        this.schema = schema;
        return this;
    }

    /**
     * The SARIF format version of this log file.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public SarifLog setVersion(final String version) {
        this.version = version;
        return this;
    }

    /**
     * The set of runs contained in this log file.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public SarifLog setRuns(final List<Run> runs) {
        this.runs = runs;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SarifLog)) {
            return false;
        }
        final SarifLog other = (SarifLog) o;
        if (!other.canEqual((java.lang.Object) this)) {
            return false;
        }
        final java.lang.Object this$schema = this.getSchema();
        final java.lang.Object other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        final java.lang.Object this$runs = this.getRuns();
        final java.lang.Object other$runs = other.getRuns();
        if (this$runs == null ? other$runs != null : !this$runs.equals(other$runs)) {
            return false;
        }
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SarifLog;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $schema = this.getSchema();
        result = result * PRIME + ($schema == null ? 43 : $schema.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        final java.lang.Object $runs = this.getRuns();
        result = result * PRIME + ($runs == null ? 43 : $runs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "SarifLog(schema=" + this.getSchema() + ", version=" + this.getVersion() + ", runs=" + this.getRuns() + ")";
    }
}
// CPD-ON
