/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.benchmark.TextTimingReportRenderer;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.benchmark.TimingReport;
import net.sourceforge.pmd.cache.NoopAnalysisCache;
import net.sourceforge.pmd.cli.PMDCommandLineInterface;
import net.sourceforge.pmd.cli.PmdParametersParseResult;
import net.sourceforge.pmd.cli.internal.CliMessages;
import net.sourceforge.pmd.internal.util.FileCollectionUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ParserOptions;
import net.sourceforge.pmd.lang.document.FileCollector;
import net.sourceforge.pmd.processor.AbstractPMDProcessor;
import net.sourceforge.pmd.processor.MonoThreadProcessor;
import net.sourceforge.pmd.processor.MultiThreadProcessor;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.database.DBMSMetadata;
import net.sourceforge.pmd.util.database.DBURI;
import net.sourceforge.pmd.util.database.SourceObject;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.ReaderDataSource;
import net.sourceforge.pmd.util.log.ScopedLogHandlersManager;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;

@Deprecated
public class PMD {
    private static final Logger LOG = Logger.getLogger(PMD.class.getName());
    @Deprecated
    public static final String EOL = System.lineSeparator();
    @Deprecated
    public static final String SUPPRESS_MARKER = "NOPMD";
    @Deprecated
    protected final PMDConfiguration configuration;
    private final SourceCodeProcessor rulesetsFileProcessor;
    @Deprecated
    public static final String VERSION = PMDVersion.VERSION;

    @Deprecated
    public PMD() {
        this(new PMDConfiguration());
    }

    @Deprecated
    public PMD(PMDConfiguration configuration) {
        this.configuration = configuration;
        this.rulesetsFileProcessor = new SourceCodeProcessor(configuration);
    }

    @Deprecated
    public static List<DataSource> getURIDataSources(String uriString) throws PMDException {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        try {
            DBURI dbUri = new DBURI(uriString);
            DBMSMetadata dbmsMetadata = new DBMSMetadata(dbUri);
            LOG.log(Level.FINE, "DBMSMetadata retrieved");
            List<SourceObject> sourceObjectList = dbmsMetadata.getSourceObjectList();
            LOG.log(Level.FINE, "Located {0} database source objects", sourceObjectList.size());
            for (SourceObject sourceObject : sourceObjectList) {
                String falseFilePath = sourceObject.getPseudoFileName();
                LOG.log(Level.FINEST, "Adding database source object {0}", falseFilePath);
                try {
                    dataSources.add(new ReaderDataSource(dbmsMetadata.getSourceCode(sourceObject), falseFilePath));
                }
                catch (SQLException ex) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Cannot get SourceCode for " + falseFilePath + "  - skipping ...", ex);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new PMDException("Cannot get DataSources from DBURI - \"" + uriString + "\"", e);
        }
        catch (SQLException e) {
            throw new PMDException("Cannot get DataSources from DBURI, couldn't access the database - \"" + uriString + "\"", e);
        }
        catch (ClassNotFoundException e) {
            throw new PMDException("Cannot get DataSources from DBURI, probably missing database jdbc driver - \"" + uriString + "\"", e);
        }
        catch (Exception e) {
            throw new PMDException("Encountered unexpected problem with URI \"" + uriString + "\"", e);
        }
        return dataSources;
    }

    @Deprecated
    @InternalApi
    public static Parser parserFor(LanguageVersion languageVersion, PMDConfiguration configuration) {
        LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
        if (languageVersionHandler == null) {
            throw new IllegalArgumentException(MessageFormat.format("Language version ''{0}'' does not support parsing!", languageVersion.getTerseName()));
        }
        ParserOptions options = languageVersionHandler.getDefaultParserOptions();
        if (configuration != null) {
            options.setSuppressMarker(configuration.getSuppressMarker());
        }
        return languageVersionHandler.getParser(options);
    }

    @Deprecated
    public PMDConfiguration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public SourceCodeProcessor getSourceCodeProcessor() {
        return this.rulesetsFileProcessor;
    }

    @Deprecated
    @InternalApi
    public static int doPMD(PMDConfiguration configuration) {
        LOG.fine("Current classpath:\n" + System.getProperty("java.class.path"));
        try (PmdAnalysis pmd = PmdAnalysis.create(configuration);){
            if (pmd.getRulesets().isEmpty()) {
                int n = pmd.getReporter().numErrors() > 0 ? -1 : 0;
                return n;
            }
            Report report = pmd.performAnalysisAndCollectReport();
            if (!report.getProcessingErrors().isEmpty()) {
                PMD.printErrorDetected(report.getProcessingErrors().size());
            }
            int n = report.getViolations().size();
            return n;
        }
    }

    @Deprecated
    public static RuleContext newRuleContext(String sourceCodeFilename, File sourceCodeFile) {
        RuleContext context = new RuleContext();
        context.setSourceCodeFile(sourceCodeFile);
        context.setReport(new Report());
        return context;
    }

    @Deprecated
    public static void processFiles(PMDConfiguration configuration, RuleSetFactory ruleSetFactory, List<DataSource> files, RuleContext ctx, List<Renderer> renderers) {
        PMD.encourageToUseIncrementalAnalysis(configuration);
        PMD.sortFiles(configuration, files);
        ctx.getReport().addListener(configuration.getAnalysisCache());
        RuleSetFactory silentFactory = ruleSetFactory.toLoader().warnDeprecated(false).toFactory();
        PMD.newFileProcessor(configuration).processFiles(silentFactory, files, ctx, renderers);
        configuration.getAnalysisCache().persist();
    }

    @Deprecated
    public static Report processFiles(PMDConfiguration configuration, List<RuleSet> rulesets, Collection<? extends DataSource> files, List<Renderer> renderers) {
        try (PmdAnalysis builder = PmdAnalysis.createWithoutCollectingFiles(configuration);){
            builder.addRuleSets(rulesets);
            builder.addRenderers(renderers);
            ArrayList<DataSource> sortedFiles = new ArrayList<DataSource>(files);
            PMD.sortFiles(configuration, sortedFiles);
            Report report = builder.performAnalysisImpl(sortedFiles);
            return report;
        }
    }

    private static void sortFiles(PMDConfiguration configuration, List<DataSource> files) {
        if (configuration.isStressTest()) {
            Collections.shuffle(files);
        } else {
            final boolean useShortNames = configuration.isReportShortNames();
            final String inputPaths = configuration.getInputPaths();
            Collections.sort(files, new Comparator<DataSource>(){

                @Override
                public int compare(DataSource left, DataSource right) {
                    String leftString = left.getNiceFileName(useShortNames, inputPaths);
                    String rightString = right.getNiceFileName(useShortNames, inputPaths);
                    return leftString.compareTo(rightString);
                }
            });
        }
    }

    static void encourageToUseIncrementalAnalysis(PMDConfiguration configuration) {
        if (!configuration.isIgnoreIncrementalAnalysis() && configuration.getAnalysisCache() instanceof NoopAnalysisCache && LOG.isLoggable(Level.WARNING)) {
            String version = PMDVersion.isUnknown() || PMDVersion.isSnapshot() ? "latest" : "pmd-" + PMDVersion.VERSION;
            LOG.warning("This analysis could be faster, please consider using Incremental Analysis: https://pmd.github.io/" + version + "/pmd_userdocs_incremental_analysis.html");
        }
    }

    private static AbstractPMDProcessor newFileProcessor(PMDConfiguration configuration) {
        return configuration.getThreads() > 0 ? new MultiThreadProcessor(configuration) : new MonoThreadProcessor(configuration);
    }

    @Deprecated
    public static List<DataSource> getApplicableFiles(PMDConfiguration configuration, Set<Language> languages) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.COLLECT_FILES);){
            FileCollector collector = FileCollectionUtil.collectFiles(configuration, languages, new SimpleMessageReporter(LOG));
            List<DataSource> list = FileCollectionUtil.collectorToDataSource(collector);
            return list;
        }
    }

    public static void main(String[] args) {
        StatusCode exitCode = PMD.runPmd(args);
        PMDCommandLineInterface.setStatusCodeOrExit(exitCode.toInt());
    }

    @Deprecated
    public static int run(String[] args) {
        return PMD.runPmd(args).toInt();
    }

    public static StatusCode runPmd(String ... args) {
        PmdParametersParseResult parseResult = PmdParametersParseResult.extractParameters(args);
        if (!parseResult.getDeprecatedOptionsUsed().isEmpty()) {
            Map.Entry<String, String> first = parseResult.getDeprecatedOptionsUsed().entrySet().iterator().next();
            LOG.warning("Some deprecated options were used on the command-line, including " + first.getKey());
            LOG.warning("Consider replacing it with " + first.getValue());
        }
        if (parseResult.isVersion()) {
            System.out.println("PMD " + PMDVersion.VERSION);
            return StatusCode.OK;
        }
        if (parseResult.isHelp()) {
            PMDCommandLineInterface.printJcommanderUsageOnConsole();
            System.out.println(PMDCommandLineInterface.buildUsageText());
            return StatusCode.OK;
        }
        if (parseResult.isError()) {
            System.err.println(parseResult.getError().getMessage());
            System.err.println(CliMessages.runWithHelpFlagMessage());
            return StatusCode.ERROR;
        }
        return PMD.runPmd(parseResult.toConfiguration());
    }

    private static void printErrorDetected(int errors) {
        String msg = CliMessages.errorDetectedMessage(errors, "PMD");
        LOG.severe(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusCode runPmd(PMDConfiguration configuration) {
        StatusCode status;
        if (configuration.isBenchmark()) {
            TimeTracker.startGlobalTracking();
        }
        Level logLevel = configuration.isDebug() ? Level.FINER : Level.INFO;
        ScopedLogHandlersManager logHandlerManager = new ScopedLogHandlersManager(logLevel, new ConsoleHandler());
        Level oldLogLevel = LOG.getLevel();
        LOG.setLevel(logLevel);
        try {
            int violations = PMD.doPMD(configuration);
            status = violations < 0 ? StatusCode.ERROR : (violations > 0 && configuration.isFailOnViolation() ? StatusCode.VIOLATIONS_FOUND : StatusCode.OK);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            status = StatusCode.ERROR;
        }
        finally {
            logHandlerManager.close();
            LOG.setLevel(oldLogLevel);
            if (configuration.isBenchmark()) {
                TimingReport timingReport = TimeTracker.stopGlobalTracking();
                TextTimingReportRenderer renderer = new TextTimingReportRenderer();
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(System.err);
                    renderer.render(timingReport, writer);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        return status;
    }

    @Deprecated
    public static enum StatusCode {
        OK(0),
        ERROR(1),
        VIOLATIONS_FOUND(4);

        private final int code;

        private StatusCode(int code) {
            this.code = code;
        }

        public int toInt() {
            return this.code;
        }
    }
}

