/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.cli.internal.CliMessages;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.util.FileUtil;
import net.sourceforge.pmd.util.database.DBURI;

@Deprecated
@InternalApi
public final class CPDCommandLineInterface {
    private static final Logger LOGGER = Logger.getLogger(CPDCommandLineInterface.class.getName());
    @Deprecated
    public static final String NO_EXIT_AFTER_RUN = "net.sourceforge.pmd.cli.noExit";
    @Deprecated
    public static final String STATUS_CODE_PROPERTY = "net.sourceforge.pmd.cli.status";
    static final String PROGRAM_NAME = "cpd";
    private static final Map<String, String> SUGGESTED_REPLACEMENT;

    private CPDCommandLineInterface() {
    }

    @Deprecated
    public static void setStatusCodeOrExit(int status) {
        if (CPDCommandLineInterface.isExitAfterRunSet()) {
            System.exit(status);
        } else {
            CPDCommandLineInterface.setStatusCode(status);
        }
    }

    private static boolean isExitAfterRunSet() {
        String noExit = System.getenv(NO_EXIT_AFTER_RUN);
        if (noExit == null) {
            noExit = System.getProperty(NO_EXIT_AFTER_RUN);
        }
        return noExit == null;
    }

    private static void setStatusCode(int statusCode) {
        System.setProperty(STATUS_CODE_PROPERTY, Integer.toString(statusCode));
    }

    static CPD.StatusCode parseArgs(CPDConfiguration arguments, String ... args) {
        JCommander jcommander = new JCommander((Object)arguments);
        jcommander.setProgramName(PROGRAM_NAME);
        try {
            jcommander.parse(args);
            if (arguments.isHelp()) {
                jcommander.usage();
                System.out.println(CPDCommandLineInterface.buildUsageText());
                return CPD.StatusCode.OK;
            }
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.println(CliMessages.runWithHelpFlagMessage());
            return CPD.StatusCode.ERROR;
        }
        Map<String, String> deprecatedOptions = CPDCommandLineInterface.filterDeprecatedOptions(args);
        if (!deprecatedOptions.isEmpty()) {
            Map.Entry<String, String> first = deprecatedOptions.entrySet().iterator().next();
            LOGGER.warning("Some deprecated options were used on the command-line, including " + first.getKey());
            LOGGER.warning("Consider replacing it with " + first.getValue());
        }
        arguments.postContruct();
        CPDConfiguration.setSystemProperties(arguments);
        return null;
    }

    @Deprecated
    public static void main(String[] args) {
        CPDCommandLineInterface.setStatusCodeOrExit(CPD.runCpd(args).toInt());
    }

    private static Map<String, String> filterDeprecatedOptions(String ... args) {
        LinkedHashMap<String, String> argSet = new LinkedHashMap<String, String>(SUGGESTED_REPLACEMENT);
        argSet.keySet().retainAll(new HashSet<String>(Arrays.asList(args)));
        return Collections.unmodifiableMap(argSet);
    }

    public static void addSourceFilesToCPD(CPD cpd, CPDConfiguration arguments) {
        if (null != arguments.getFiles() && !arguments.getFiles().isEmpty()) {
            CPDCommandLineInterface.addSourcesFilesToCPD(arguments.getFiles(), cpd, !arguments.isNonRecursive());
        }
        if (null != arguments.getURI() && !"".equals(arguments.getURI())) {
            CPDCommandLineInterface.addSourceURIToCPD(arguments.getURI(), cpd);
        }
        if (null != arguments.getFileListPath() && !"".equals(arguments.getFileListPath())) {
            CPDCommandLineInterface.addFilesFromFilelist(arguments.getFileListPath(), cpd, !arguments.isNonRecursive());
        }
    }

    private static void addSourcesFilesToCPD(List<File> files, CPD cpd, boolean recursive) {
        try {
            for (File file : files) {
                if (!file.exists()) {
                    throw new FileNotFoundException("Couldn't find directory/file '" + file + "'");
                }
                if (file.isDirectory()) {
                    if (recursive) {
                        cpd.addRecursively(file);
                        continue;
                    }
                    cpd.addAllInDirectory(file);
                    continue;
                }
                cpd.add(file);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void addFilesFromFilelist(String inputFilePath, CPD cpd, boolean recursive) {
        File file = new File(inputFilePath);
        ArrayList<File> files = new ArrayList<File>();
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("Couldn't find directory/file '" + inputFilePath + "'");
            }
            String filePaths = FileUtil.readFilelist(new File(inputFilePath));
            for (String param : filePaths.split(",")) {
                File fileToAdd = new File(param);
                if (!fileToAdd.exists()) {
                    throw new FileNotFoundException("Couldn't find directory/file '" + param + "'");
                }
                files.add(fileToAdd);
            }
            CPDCommandLineInterface.addSourcesFilesToCPD(files, cpd, recursive);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void addSourceURIToCPD(String uri, CPD cpd) {
        try {
            LOGGER.fine(String.format("Attempting DBURI=%s", uri));
            DBURI dburi = new DBURI(uri);
            LOGGER.fine(String.format("Initialised DBURI=%s", dburi));
            LOGGER.fine(String.format("Adding DBURI=%s with DBType=%s", dburi.toString(), dburi.getDbType().toString()));
            cpd.add(dburi);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("uri=" + uri, e);
        }
    }

    @Deprecated
    @InternalApi
    public static String buildUsageText() {
        String helpText = " For example on Windows:" + PMD.EOL;
        helpText = helpText + " C:\\>pmd-bin-" + PMDVersion.VERSION + "\\bin\\cpd.bat --minimum-tokens 100 --files c:\\jdk18\\src\\java" + PMD.EOL;
        helpText = helpText + PMD.EOL;
        helpText = helpText + " For example on *nix:" + PMD.EOL;
        helpText = helpText + " $ pmd-bin-" + PMDVersion.VERSION + "/bin/run.sh cpd --minimum-tokens 100 --files /path/to/java/code" + PMD.EOL;
        helpText = helpText + PMD.EOL;
        helpText = helpText + " Supported languages: " + Arrays.toString(LanguageFactory.supportedLanguages) + PMD.EOL;
        helpText = helpText + " Formats: " + Arrays.toString(CPDConfiguration.getRenderers()) + PMD.EOL;
        return helpText;
    }

    static {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("--failOnViolation", "--fail-on-violation");
        m.put("-failOnViolation", "--fail-on-violation");
        m.put("--filelist", "--file-list");
        m.put("--files", "--dir");
        SUGGESTED_REPLACEMENT = Collections.unmodifiableMap(m);
    }
}

