/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.dcd.DumpNodeVisitor;
import net.sourceforge.pmd.dcd.UsageNodeVisitor;
import net.sourceforge.pmd.dcd.graph.UsageGraph;
import net.sourceforge.pmd.dcd.graph.UsageGraphBuilder;
import net.sourceforge.pmd.util.FileFinder;
import net.sourceforge.pmd.util.filter.Filter;
import net.sourceforge.pmd.util.filter.Filters;

@Deprecated
public final class DCD {
    private DCD() {
    }

    public static void dump(UsageGraph usageGraph, boolean verbose) {
        usageGraph.accept(new DumpNodeVisitor(), verbose);
    }

    public static void report(UsageGraph usageGraph, boolean verbose) {
        usageGraph.accept(new UsageNodeVisitor(), verbose);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<File> directories = new ArrayList<File>();
        directories.add(new File("C:/pmd/workspace/pmd-trunk/src"));
        FilenameFilter javaFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                return name.endsWith(".java");
            }
        };
        ArrayList<1> filters = new ArrayList<1>();
        filters.add(javaFilter);
        assert (directories.size() == filters.size());
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < directories.size(); ++i) {
            File directory = (File)directories.get(i);
            FilenameFilter filter = (FilenameFilter)filters.get(i);
            List<File> files = new FileFinder().findFilesFrom(directory, filter, true);
            for (File file : files) {
                String name = file.getPath();
                name = name.substring(directory.getPath().length() + 1);
                name = name.replaceAll("\\.java$", "");
                name = name.replace('\\', '.');
                name = name.replace('/', '.');
                classes.add(name);
            }
        }
        long start = System.currentTimeMillis();
        List<String> includeRegexes = Arrays.asList("net\\.sourceforge\\.pmd\\.dcd.*", "us\\..*");
        List<String> excludeRegexes = Arrays.asList("java\\..*", "javax\\..*", ".*\\.twa\\..*");
        Filter<String> classFilter = Filters.buildRegexFilterExcludeOverInclude(includeRegexes, excludeRegexes);
        System.out.println("Class filter: " + classFilter);
        UsageGraphBuilder builder = new UsageGraphBuilder(classFilter);
        int total = 0;
        for (String clazz : classes) {
            System.out.println("indexing class: " + clazz);
            builder.index(clazz);
            if (++total % 20 != 0) continue;
            System.out.println(total + " : " + (double)total / ((double)(System.currentTimeMillis() - start) / 1000.0));
        }
        boolean dump = true;
        boolean deadCode = true;
        UsageGraph usageGraph = builder.getUsageGraph();
        if (dump) {
            System.out.println("--- Dump ---");
            DCD.dump(usageGraph, true);
        }
        if (deadCode) {
            System.out.println("--- Dead Code ---");
            DCD.report(usageGraph, true);
        }
        long end = System.currentTimeMillis();
        System.out.println("Time: " + (double)(end - start) / 1000.0);
    }
}

