/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.internal.util.AssertionUtil;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.internal.LanguageAwareDataSource;
import net.sourceforge.pmd.util.datasource.internal.PathDataSource;

@Experimental
class NioTextFile
implements TextFile {
    private final Path path;
    private final Charset charset;
    private final LanguageVersion languageVersion;
    private final String displayName;
    private final String pathId;

    NioTextFile(Path path, Charset charset, LanguageVersion languageVersion, String displayName) {
        AssertionUtil.requireParamNotNull("path", path);
        AssertionUtil.requireParamNotNull("charset", charset);
        AssertionUtil.requireParamNotNull("language version", languageVersion);
        this.displayName = displayName;
        this.path = path;
        this.charset = charset;
        this.languageVersion = languageVersion;
        this.pathId = path.toUri().toString();
    }

    @Override
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getPathId() {
        return this.pathId;
    }

    @Override
    public String readContents() throws IOException {
        if (!Files.isRegularFile(this.path, new LinkOption[0])) {
            throw new IOException("Not a regular file: " + this.path);
        }
        try (BufferedReader br = Files.newBufferedReader(this.path, this.charset);){
            String string = IOUtil.readToString(br);
            return string;
        }
    }

    @Override
    public DataSource toDataSourceCompat() {
        return new LanguageAwareDataSource(new PathDataSource(this.path), this.languageVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NioTextFile that = (NioTextFile)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.pathId);
    }

    public String toString() {
        return this.getPathId();
    }
}

