/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.internal.DeprecatedAttrLogger;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.xpath.JaxenXPathRuleQuery;
import net.sourceforge.pmd.lang.rule.xpath.SaxonXPathRuleQuery;
import net.sourceforge.pmd.lang.rule.xpath.XPathRuleQuery;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.properties.EnumeratedProperty;
import net.sourceforge.pmd.properties.StringProperty;
import org.apache.commons.lang3.StringUtils;

public class XPathRule
extends AbstractRule {
    @Deprecated
    public static final StringProperty XPATH_DESCRIPTOR = ((StringProperty.StringPBuilder)((StringProperty.StringPBuilder)((StringProperty.StringPBuilder)StringProperty.named("xpath").desc("XPath expression")).defaultValue("")).uiOrder(1.0f)).build();
    private static final Map<String, String> XPATH_VERSIONS;
    @Deprecated
    public static final EnumeratedProperty<String> VERSION_DESCRIPTOR;
    private XPathRuleQuery xpathRuleQuery;
    private DeprecatedAttrLogger attrLogger = DeprecatedAttrLogger.create(this);

    public XPathRule() {
        this.definePropertyDescriptor(XPATH_DESCRIPTOR);
        this.definePropertyDescriptor(VERSION_DESCRIPTOR);
        super.setTypeResolution(true);
    }

    public XPathRule(String xPath) {
        this();
        this.setXPath(xPath);
    }

    public XPathRule(XPathVersion version, String expression) {
        this();
        Objects.requireNonNull(version, "XPath version is null");
        Objects.requireNonNull(expression, "XPath expression is null");
        this.setXPath(expression);
        this.setVersion(version.getXmlName());
    }

    @Override
    public Rule deepCopy() {
        XPathRule rule = (XPathRule)super.deepCopy();
        rule.attrLogger = this.attrLogger;
        return rule;
    }

    public XPathVersion getVersion() {
        return XPathVersion.ofId(this.getProperty(VERSION_DESCRIPTOR));
    }

    public String getXPathExpression() {
        return this.getProperty(XPATH_DESCRIPTOR);
    }

    @Deprecated
    public void setXPath(String xPath) {
        this.setProperty(XPATH_DESCRIPTOR, xPath);
    }

    @Deprecated
    public void setVersion(String version) {
        this.setProperty(VERSION_DESCRIPTOR, version);
    }

    @Override
    public void apply(List<? extends Node> nodes, RuleContext ctx) {
        for (Node node : nodes) {
            this.evaluate(node, ctx);
        }
    }

    @Deprecated
    public void evaluate(Node node, RuleContext data) {
        if (this.xPathRuleQueryNeedsInitialization()) {
            this.initXPathRuleQuery();
        }
        List<Node> nodesWithViolation = this.xpathRuleQuery.evaluate(node, data);
        for (Node nodeWithViolation : nodesWithViolation) {
            this.addViolation((Object)data, nodeWithViolation, nodeWithViolation.getImage());
        }
    }

    private void initXPathRuleQuery() {
        String xpath = this.getXPathExpression();
        XPathVersion version = this.getVersion();
        if (version == null) {
            throw new IllegalStateException("Invalid XPath version, should have been caught by Rule::dysfunctionReason");
        }
        this.xpathRuleQuery = version == XPathVersion.XPATH_1_0 ? new JaxenXPathRuleQuery(this.attrLogger) : new SaxonXPathRuleQuery(this.attrLogger);
        this.xpathRuleQuery.setXPath(xpath);
        this.xpathRuleQuery.setVersion(version.getXmlName());
        this.xpathRuleQuery.setProperties(this.getPropertiesByPropertyDescriptor());
    }

    private boolean xPathRuleQueryNeedsInitialization() {
        return this.xpathRuleQuery == null;
    }

    @Override
    public List<String> getRuleChainVisits() {
        if (this.xPathRuleQueryNeedsInitialization()) {
            this.initXPathRuleQuery();
            for (String nodeName : this.xpathRuleQuery.getRuleChainVisits()) {
                super.addRuleChainVisit(nodeName);
            }
        }
        return super.getRuleChainVisits();
    }

    @Override
    public String dysfunctionReason() {
        if (this.getVersion() == null) {
            return "Invalid XPath version '" + this.getProperty(VERSION_DESCRIPTOR) + "'";
        }
        if (StringUtils.isBlank((CharSequence)this.getXPathExpression())) {
            return "Missing XPath expression";
        }
        return null;
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("1.0", "1.0");
        tmp.put("1.0 compatibility", "1.0 compatibility");
        tmp.put("2.0", "2.0");
        XPATH_VERSIONS = Collections.unmodifiableMap(tmp);
        VERSION_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)((EnumeratedProperty.EnumPBuilder)((EnumeratedProperty.EnumPBuilder)EnumeratedProperty.named("version").desc("XPath specification version")).mappings(XPATH_VERSIONS).defaultValue("1.0")).type(String.class).uiOrder(2.0f)).build();
    }
}

