/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.processor.AbstractPMDProcessor;
import net.sourceforge.pmd.processor.PmdRunnable;
import net.sourceforge.pmd.processor.PmdThreadFactory;
import net.sourceforge.pmd.renderers.Renderer;

@Deprecated
@InternalApi
public class MultiThreadProcessor
extends AbstractPMDProcessor {
    private final ExecutorService executor;
    private final CompletionService<Report> completionService;
    private long submittedTasks = 0L;

    public MultiThreadProcessor(PMDConfiguration configuration) {
        super(configuration);
        this.executor = Executors.newFixedThreadPool(configuration.getThreads(), new PmdThreadFactory());
        this.completionService = new ExecutorCompletionService<Report>(this.executor);
    }

    @Override
    protected void runAnalysis(PmdRunnable runnable) {
        this.completionService.submit(runnable);
        ++this.submittedTasks;
    }

    @Override
    protected void collectReports(List<Renderer> renderers) {
        try {
            int i = 0;
            while ((long)i < this.submittedTasks) {
                Report report = this.completionService.take().get();
                super.renderReports(renderers, report);
                ++i;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ee) {
            Throwable t = ee.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IllegalStateException("PmdRunnable exception", t);
        }
        finally {
            this.executor.shutdownNow();
        }
    }
}

