/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.util.FileFinder;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.FileDataSource;
import net.sourceforge.pmd.util.datasource.ZipDataSource;
import net.sourceforge.pmd.util.filter.AndFilter;
import net.sourceforge.pmd.util.filter.Filters;
import net.sourceforge.pmd.util.filter.OrFilter;
import org.apache.commons.lang3.StringUtils;

@Deprecated
@InternalApi
public final class FileUtil {
    private FileUtil() {
    }

    public static String getFileNameWithoutExtension(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    public static String normalizeFilename(String fileName) {
        if (fileName != null && File.separatorChar == '\\') {
            return fileName.toLowerCase(Locale.ROOT);
        }
        return fileName;
    }

    public static List<DataSource> collectFiles(String fileLocations, FilenameFilter filenameFilter) {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        for (String fileLocation : fileLocations.split(",")) {
            FileUtil.collect(dataSources, fileLocation, filenameFilter);
        }
        return dataSources;
    }

    private static List<DataSource> collect(List<DataSource> dataSources, String fileLocation, FilenameFilter filenameFilter) {
        File file = new File(fileLocation);
        if (!file.exists()) {
            throw new RuntimeException("File " + file.getName() + " doesn't exist");
        }
        if (!file.isDirectory()) {
            if (fileLocation.endsWith(".zip") || fileLocation.endsWith(".jar")) {
                try {
                    ZipFile zipFile = new ZipFile(fileLocation);
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zipEntry = e.nextElement();
                        if (!filenameFilter.accept(null, zipEntry.getName())) continue;
                        dataSources.add(new ZipDataSource(zipFile, zipEntry));
                    }
                }
                catch (IOException ze) {
                    throw new RuntimeException("Archive file " + file.getName() + " can't be opened");
                }
            } else {
                dataSources.add(new FileDataSource(file));
            }
        } else {
            OrFilter<File> filter = new OrFilter<File>(Filters.toFileFilter(filenameFilter), new AndFilter(Filters.getDirectoryFilter(), Filters.toNormalizedFileFilter(Filters.buildRegexFilterExcludeOverInclude(null, Collections.singletonList("SCCS")))));
            FileFinder finder = new FileFinder();
            List<File> files = finder.findFilesFrom(file, Filters.toFilenameFilter(filter), true);
            for (File f : files) {
                dataSources.add(new FileDataSource(f));
            }
        }
        return dataSources;
    }

    public static boolean findPatternInFile(File file, String pattern) {
        Pattern regexp = Pattern.compile(pattern);
        Matcher matcher = regexp.matcher("");
        try {
            for (String line : Files.readAllLines(file.toPath(), StandardCharsets.UTF_8)) {
                matcher.reset(line);
                if (!matcher.find()) continue;
                return true;
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static String readFilelist(File filelist) throws IOException {
        String filePaths = IOUtil.readFileToString(filelist);
        filePaths = StringUtils.trimToEmpty((String)filePaths);
        filePaths = filePaths.replaceAll("\\r?\\n", ",");
        filePaths = filePaths.replaceAll(",+", ",");
        return filePaths;
    }
}

