/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.datasource.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.internal.util.ShortFilenameUtil;
import net.sourceforge.pmd.util.datasource.internal.AbstractDataSource;

public class PathDataSource
extends AbstractDataSource {
    private final Path path;

    public PathDataSource(Path path) {
        this.path = path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public String getNiceFileName(boolean shortNames, String inputPaths) {
        return this.glomName(shortNames, inputPaths);
    }

    private String getAbsoluteFilePath() {
        if ("jar".equals(this.path.toUri().getScheme())) {
            return new File(URI.create(this.path.toUri().getSchemeSpecificPart()).getPath()).toString();
        }
        return this.path.toFile().getAbsolutePath();
    }

    private String getSimpleFilePath() {
        if ("jar".equals(this.path.toUri().getScheme())) {
            String[] zipAndFile = URI.create(this.path.toUri().getSchemeSpecificPart()).getPath().split("!");
            return new File(zipAndFile[0]).getName() + "!" + new File(zipAndFile[1]).getName();
        }
        return this.path.toFile().getName();
    }

    private String glomName(boolean shortNames, String inputPaths) {
        if (shortNames) {
            if (inputPaths != null) {
                List<String> inputPathPrefixes = Arrays.asList(inputPaths.split(","));
                String absoluteFilePath = this.getAbsoluteFilePath();
                return ShortFilenameUtil.determineFileName(inputPathPrefixes, absoluteFilePath);
            }
            return this.getSimpleFilePath();
        }
        try {
            return this.path.toFile().getCanonicalFile().getAbsolutePath();
        }
        catch (Exception e) {
            return this.getAbsoluteFilePath();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.path.toUri() + ']';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathDataSource other = (PathDataSource)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

