/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.pmd.cache.internal.ClasspathEntryFingerprinter;

public class ZipFileFingerprinter
implements ClasspathEntryFingerprinter {
    private static final Logger LOG = Logger.getLogger(ZipFileFingerprinter.class.getName());
    private static final Set<String> SUPPORTED_EXTENSIONS;
    private static final Set<String> SUPPORTED_ENTRY_EXTENSIONS;
    private static final Comparator<ZipEntry> FILE_NAME_COMPARATOR;

    @Override
    public boolean appliesTo(String fileExtension) {
        return SUPPORTED_EXTENSIONS.contains(fileExtension);
    }

    @Override
    public void fingerprint(URL entry, Checksum checksum) throws IOException {
        try (ZipFile zip = new ZipFile(new File(entry.toURI()));){
            List<ZipEntry> meaningfulEntries = this.getMeaningfulEntries(zip);
            Collections.sort(meaningfulEntries, FILE_NAME_COMPARATOR);
            ByteBuffer buffer = ByteBuffer.allocate(4);
            for (ZipEntry zipEntry : meaningfulEntries) {
                buffer.putInt(0, (int)zipEntry.getCrc());
                checksum.update(buffer.array(), 0, 4);
            }
        }
        catch (FileNotFoundException | NoSuchFileException ignored) {
            LOG.warning("Classpath entry " + entry.toString() + " doesn't exist, ignoring it");
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Malformed classpath entry doesn't refer to zip in filesystem.", e);
        }
    }

    private List<ZipEntry> getMeaningfulEntries(ZipFile zip) {
        ArrayList<ZipEntry> meaningfulEntries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!SUPPORTED_ENTRY_EXTENSIONS.contains(this.getFileExtension(zipEntry))) continue;
            meaningfulEntries.add(zipEntry);
        }
        return meaningfulEntries;
    }

    private String getFileExtension(ZipEntry entry) {
        if (entry.isDirectory()) {
            return null;
        }
        String file = entry.getName();
        int lastDot = file.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return file.substring(lastDot + 1);
    }

    static {
        FILE_NAME_COMPARATOR = new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry o1, ZipEntry o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("jar");
        extensions.add("zip");
        SUPPORTED_EXTENSIONS = Collections.unmodifiableSet(extensions);
        HashSet<String> entryExtensions = new HashSet<String>();
        entryExtensions.add("class");
        SUPPORTED_ENTRY_EXTENSIONS = Collections.unmodifiableSet(entryExtensions);
    }
}

