/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import net.sourceforge.pmd.cpd.renderer.CPDReportRenderer;
import org.apache.commons.lang3.StringEscapeUtils;

public class CSVRenderer
implements Renderer,
CPDRenderer,
CPDReportRenderer {
    private final char separator;
    private final boolean lineCountPerFile;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final boolean DEFAULT_LINECOUNTPERFILE = false;

    public CSVRenderer() {
        this(',', false);
    }

    public CSVRenderer(boolean lineCountPerFile) {
        this(',', lineCountPerFile);
    }

    public CSVRenderer(char separatorChar) {
        this(separatorChar, false);
    }

    public CSVRenderer(char separatorChar, boolean lineCountPerFile) {
        this.separator = separatorChar;
        this.lineCountPerFile = lineCountPerFile;
    }

    @Override
    public String render(Iterator<Match> matches) {
        StringWriter writer = new StringWriter(1000);
        try {
            this.render(matches, (Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    public void render(Iterator<Match> matches, Writer writer) throws IOException {
        if (!this.lineCountPerFile) {
            writer.append("lines").append(this.separator);
        }
        writer.append("tokens").append(this.separator).append("occurrences").append(PMD.EOL);
        while (matches.hasNext()) {
            Match match = matches.next();
            if (!this.lineCountPerFile) {
                writer.append(String.valueOf(match.getLineCount())).append(this.separator);
            }
            writer.append(String.valueOf(match.getTokenCount())).append(this.separator).append(String.valueOf(match.getMarkCount())).append(this.separator);
            Iterator<Mark> marks = match.iterator();
            while (marks.hasNext()) {
                Mark mark = marks.next();
                writer.append(String.valueOf(mark.getBeginLine())).append(this.separator);
                if (this.lineCountPerFile) {
                    writer.append(String.valueOf(mark.getLineCount())).append(this.separator);
                }
                writer.append(StringEscapeUtils.escapeCsv((String)mark.getFilename()));
                if (!marks.hasNext()) continue;
                writer.append(this.separator);
            }
            writer.append(PMD.EOL);
        }
        writer.flush();
    }

    @Override
    public void render(CPDReport report, Writer writer) throws IOException {
        this.render(report.getMatches().iterator(), writer);
    }
}

