/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <T> Iterator<T> reverse(Iterator<T> it) {
        List<T> tmp = IteratorUtil.toList(it);
        Collections.reverse(tmp);
        return tmp.iterator();
    }

    public static <T> List<T> toList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static <T> Iterable<T> toIterable(final Iterator<T> it) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return it;
            }
        };
    }

    public static int count(Iterator<?> it) {
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static <T> Iterable<T> asReversed(final List<T> lst) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    ListIterator<T> li;
                    {
                        this.li = lst.listIterator(lst.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.li.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return this.li.previous();
                    }

                    @Override
                    public void remove() {
                        this.li.remove();
                    }
                };
            }
        };
    }

    public static abstract class AbstractIterator<T>
    implements Iterator<T> {
        private State state = State.NOT_READY;
        private T next = null;

        @Override
        public boolean hasNext() {
            switch (this.state) {
                case DONE: {
                    return false;
                }
                case READY: {
                    return true;
                }
            }
            this.state = null;
            this.computeNext();
            if (this.state == null) {
                throw new IllegalStateException("Should have called done or setNext");
            }
            return this.state == State.READY;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.state = State.NOT_READY;
            return this.next;
        }

        protected final void setNext(T t) {
            this.next = t;
            this.state = State.READY;
        }

        protected final void done() {
            this.state = State.DONE;
        }

        protected abstract void computeNext();

        @Override
        @Deprecated
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        static enum State {
            READY,
            NOT_READY,
            DONE;

        }
    }
}

