/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath.internal;

import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.DataMap;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.SimpleFunctionContext;
import org.jaxen.XPathFunctionContext;

public class FileNameXPathFunction
implements Function {
    public static final DataMap.SimpleDataKey<String> FILE_NAME_KEY = DataMap.simpleDataKey("pmd.fileName");
    private final String name;

    public static void registerSelfInSimpleContext() {
        ((SimpleFunctionContext)XPathFunctionContext.getInstance()).registerFunction(null, "fileName", new FileNameXPathFunction("fileName"));
    }

    public FileNameXPathFunction(String name) {
        this.name = name;
    }

    @Override
    public Object call(Context context, List args) throws FunctionCallException {
        if (!args.isEmpty()) {
            throw new IllegalArgumentException(this.name + " function takes no arguments.");
        }
        Node n = (Node)context.getNodeSet().get(0);
        return FileNameXPathFunction.getFileName(n);
    }

    public static String getFileName(Node n) {
        while (n.getParent() != null) {
            n = n.getParent();
        }
        Objects.requireNonNull(n, "No root node in tree?");
        String fileName = (String)n.getUserMap().get(FILE_NAME_KEY);
        return Objects.requireNonNull(fileName, "File name was not set");
    }
}

