/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document.internal;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import org.apache.commons.lang3.StringUtils;

public class LanguageDiscoverer {
    private final Language forcedLanguage;

    public LanguageDiscoverer(Language forcedLanguage) {
        this.forcedLanguage = forcedLanguage;
    }

    public List<Language> getLanguagesForFile(Path sourceFile) {
        return this.getLanguagesForFile(sourceFile.getFileName().toString());
    }

    public List<Language> getLanguagesForFile(String fileName) {
        if (this.forcedLanguage != null) {
            return Collections.singletonList(this.forcedLanguage);
        }
        String extension = this.getExtension(fileName);
        return LanguageRegistry.findByExtension(extension);
    }

    private String getExtension(String fileName) {
        return StringUtils.substringAfterLast((String)fileName, (String)".");
    }
}

