/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.om.Axis;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonExprVisitor;

public class ExpressionPrinter
extends SaxonExprVisitor {
    private int depth = 0;

    private void print(String s) {
        for (int i = 0; i < this.depth; ++i) {
            System.out.print("    ");
        }
        System.out.println(s);
    }

    @Override
    public Expression visit(AxisExpression e) {
        this.print("axis=" + Axis.axisName[e.getAxis()] + "(test=" + e.getNodeTest() + ")");
        return super.visit(e);
    }

    @Override
    public Expression visit(RootExpression e) {
        this.print("/");
        return super.visit(e);
    }

    @Override
    public Expression visit(VennExpression e) {
        this.print("venn=" + Token.tokens[e.getOperator()]);
        return super.visit(e);
    }

    @Override
    public Expression visit(Expression expr) {
        ++this.depth;
        this.print(expr.getClass().getSimpleName());
        Expression result = super.visit(expr);
        --this.depth;
        return result;
    }
}

