/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.renderers.internal.sarif.SarifLog;
import net.sourceforge.pmd.renderers.internal.sarif.SarifLogBuilder;
import net.sourceforge.pmd.util.IOUtil;

public class SarifRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "sarif";
    private static final String DEFAULT_DESCRIPTION = "Static Analysis Results Interchange Format (SARIF)";
    private static final String DEFAULT_FILE_EXTENSION = "sarif.json";
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private SarifLogBuilder sarifLogBuilder;

    public SarifRenderer() {
        super(NAME, DEFAULT_DESCRIPTION);
    }

    @Override
    public String defaultFileExtension() {
        return DEFAULT_FILE_EXTENSION;
    }

    @Override
    public void start() throws IOException {
        this.sarifLogBuilder = SarifLogBuilder.sarifLogBuilder();
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        while (violations.hasNext()) {
            RuleViolation violation = violations.next();
            this.sarifLogBuilder.add(violation);
        }
    }

    @Override
    public void end() throws IOException {
        this.addErrors();
        this.writeLog();
    }

    private void addErrors() {
        for (Object error : this.errors) {
            this.sarifLogBuilder.addRunTimeError((Report.ProcessingError)error);
        }
        for (Object error : this.configErrors) {
            this.sarifLogBuilder.addConfigurationError((Report.ConfigurationError)error);
        }
    }

    private void writeLog() throws IOException {
        SarifLog sarifLog = this.sarifLogBuilder.build();
        String json = this.gson.toJson((Object)sarifLog);
        this.writer.write(json);
    }

    @Override
    public void setReportFile(String reportFilename) {
        this.setWriter(IOUtil.createWriter(StandardCharsets.UTF_8, reportFilename));
    }
}

