/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.ResourceLoader;
import org.apache.commons.lang3.StringUtils;

@Deprecated
@InternalApi
public class RuleBuilder {
    private List<PropertyDescriptor<?>> definedProperties = new ArrayList();
    private String name;
    private ResourceLoader resourceLoader;
    private String clazz;
    private Language language;
    private String minimumVersion;
    private String maximumVersion;
    private String since;
    private String message;
    private String externalInfoUrl;
    private String description;
    private List<String> examples = new ArrayList<String>(1);
    private RulePriority priority;
    private boolean isDeprecated;
    private boolean isUsesDfa;
    private boolean isUsesMultifile;
    private boolean isUsesTyperesolution;

    @Deprecated
    public RuleBuilder(String name, String clazz, String language) {
        this(name, new ResourceLoader(), clazz, language);
    }

    public RuleBuilder(String name, ResourceLoader resourceLoader, String clazz, String language) {
        this.name = name;
        this.resourceLoader = resourceLoader;
        this.language(language);
        this.className(clazz);
    }

    public void usesDFA(boolean usesDFA) {
        this.isUsesDfa = usesDFA;
    }

    public void usesMultifile(boolean usesMultifile) {
        this.isUsesMultifile = usesMultifile;
    }

    public void usesTyperesolution(boolean usesTyperesolution) {
        this.isUsesTyperesolution = usesTyperesolution;
    }

    private void language(String languageName) {
        if (StringUtils.isBlank((CharSequence)languageName)) {
            return;
        }
        Language lang = LanguageRegistry.findLanguageByTerseName(languageName);
        if (lang == null) {
            throw new IllegalArgumentException("Unknown Language '" + languageName + "' for rule " + this.name + ", supported Languages are " + LanguageRegistry.commaSeparatedTerseNamesForLanguage(LanguageRegistry.findWithRuleSupport()));
        }
        this.language = lang;
    }

    private void className(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            throw new IllegalArgumentException("The 'class' field of rule can't be null, nor empty.");
        }
        this.clazz = className;
    }

    public void minimumLanguageVersion(String minimum) {
        this.minimumVersion = minimum;
    }

    public void maximumLanguageVersion(String maximum) {
        this.maximumVersion = maximum;
    }

    private void checkLanguageVersionsAreOrdered(Rule rule) {
        if (rule.getMinimumLanguageVersion() != null && rule.getMaximumLanguageVersion() != null && rule.getMinimumLanguageVersion().compareTo(rule.getMaximumLanguageVersion()) > 0) {
            throw new IllegalArgumentException("The minimum Language Version '" + rule.getMinimumLanguageVersion().getTerseName() + "' must be prior to the maximum Language Version '" + rule.getMaximumLanguageVersion().getTerseName() + "' for Rule '" + this.name + "'; perhaps swap them around?");
        }
    }

    public void since(String sinceStr) {
        if (StringUtils.isNotBlank((CharSequence)sinceStr)) {
            this.since = sinceStr;
        }
    }

    public void externalInfoUrl(String externalInfoUrl) {
        this.externalInfoUrl = externalInfoUrl;
    }

    public void message(String message) {
        this.message = message;
    }

    public void defineProperty(PropertyDescriptor<?> descriptor) {
        this.definedProperties.add(descriptor);
    }

    public void setDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    public void description(String description) {
        this.description = description;
    }

    public void addExample(String example) {
        this.examples.add(example);
    }

    public void priority(int priorityString) {
        this.priority = RulePriority.valueOf(priorityString);
    }

    private void loadLanguageMinMaxVersions(Rule rule) {
        if (this.minimumVersion != null) {
            LanguageVersion minimumLanguageVersion = rule.getLanguage().getVersion(this.minimumVersion);
            if (minimumLanguageVersion == null) {
                this.throwUnknownLanguageVersionException("minimum", this.minimumVersion, rule.getLanguage());
            } else {
                rule.setMinimumLanguageVersion(minimumLanguageVersion);
            }
        }
        if (this.maximumVersion != null) {
            LanguageVersion maximumLanguageVersion = rule.getLanguage().getVersion(this.maximumVersion);
            if (maximumLanguageVersion == null) {
                this.throwUnknownLanguageVersionException("maximum", this.maximumVersion, rule.getLanguage());
            } else {
                rule.setMaximumLanguageVersion(maximumLanguageVersion);
            }
        }
        this.checkLanguageVersionsAreOrdered(rule);
    }

    private void throwUnknownLanguageVersionException(String minOrMax, String unknownVersion, Language lang) {
        throw new IllegalArgumentException("Unknown " + minOrMax + " Language Version '" + unknownVersion + "' for Language '" + lang.getTerseName() + "' for Rule " + this.name + "; supported Language Versions are: " + LanguageRegistry.commaSeparatedTerseNamesForLanguageVersion(lang.getVersions()));
    }

    public Rule build() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Rule rule = this.resourceLoader.loadRuleFromClassPath(this.clazz);
        rule.setName(this.name);
        rule.setRuleClass(this.clazz);
        if (rule.getLanguage() == null) {
            rule.setLanguage(this.language);
        }
        this.loadLanguageMinMaxVersions(rule);
        rule.setSince(this.since);
        rule.setMessage(this.message);
        rule.setExternalInfoUrl(this.externalInfoUrl);
        rule.setDeprecated(this.isDeprecated);
        rule.setDescription(this.description);
        rule.setPriority(this.priority == null ? RulePriority.LOW : this.priority);
        for (String string : this.examples) {
            rule.addExample(string);
        }
        if (this.isUsesDfa) {
            rule.setDfa(this.isUsesDfa);
        }
        if (this.isUsesMultifile) {
            rule.setMultifile(this.isUsesMultifile);
        }
        if (this.isUsesTyperesolution) {
            rule.setTypeResolution(this.isUsesTyperesolution);
        }
        for (PropertyDescriptor propertyDescriptor : this.definedProperties) {
            if (rule.getPropertyDescriptors().contains(propertyDescriptor)) continue;
            rule.definePropertyDescriptor(propertyDescriptor);
        }
        return rule;
    }
}

