/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.antlr.AntlrTokenManager;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;

public abstract class AntlrTokenizer
implements Tokenizer {
    protected abstract AntlrTokenManager getLexerForSource(SourceCode var1);

    @Override
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        AntlrTokenManager tokenManager = this.getLexerForSource(sourceCode);
        try {
            Token token = (Token)tokenManager.getNextToken();
            while (token.getType() != -1) {
                if (token.getChannel() != 1) {
                    TokenEntry tokenEntry = new TokenEntry(token.getText(), tokenManager.getFileName(), token.getLine());
                    tokenEntries.add(tokenEntry);
                }
                token = (Token)tokenManager.getNextToken();
            }
        }
        catch (AntlrTokenManager.ANTLRSyntaxError err) {
            throw new TokenMgrError("Lexical error in file " + tokenManager.getFileName() + " at line " + err.getLine() + ", column " + err.getColumn() + ".  Encountered: " + err.getMessage(), 0);
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }

    static CharStream getCharStreamFromSourceCode(SourceCode sourceCode) {
        StringBuilder buffer = sourceCode.getCodeBuffer();
        return CharStreams.fromString((String)buffer.toString());
    }
}

