/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.properties.AbstractNumericProperty;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorBuilderConversionWrapper;
import net.sourceforge.pmd.properties.builders.SingleNumericPropertyBuilder;

public final class DoubleProperty
extends AbstractNumericProperty<Double> {
    public DoubleProperty(String theName, String theDescription, String minStr, String maxStr, String defaultStr, float theUIOrder) {
        this(theName, theDescription, DoubleProperty.doubleFrom(minStr), DoubleProperty.doubleFrom(maxStr), DoubleProperty.doubleFrom(defaultStr), theUIOrder, false);
    }

    private DoubleProperty(String theName, String theDescription, Double min, Double max, Double theDefault, float theUIOrder, boolean isDefinedExternally) {
        super(theName, theDescription, min, max, theDefault, theUIOrder, isDefinedExternally);
    }

    public DoubleProperty(String theName, String theDescription, Double min, Double max, Double theDefault, float theUIOrder) {
        this(theName, theDescription, min, max, theDefault, theUIOrder, false);
    }

    @Override
    public Class<Double> type() {
        return Double.class;
    }

    @Override
    protected Double createFrom(String value) {
        return DoubleProperty.doubleFrom(value);
    }

    private static Double doubleFrom(String numberString) {
        return ValueParserConstants.DOUBLE_PARSER.valueOf(numberString);
    }

    static PropertyDescriptorBuilderConversionWrapper.SingleValue.Numeric<Double, DoublePBuilder> extractor() {
        return new PropertyDescriptorBuilderConversionWrapper.SingleValue.Numeric<Double, DoublePBuilder>(Double.class, ValueParserConstants.DOUBLE_PARSER){

            @Override
            protected DoublePBuilder newBuilder(String name) {
                return new DoublePBuilder(name);
            }
        };
    }

    public static DoublePBuilder named(String name) {
        return new DoublePBuilder(name);
    }

    public static final class DoublePBuilder
    extends SingleNumericPropertyBuilder<Double, DoublePBuilder> {
        private DoublePBuilder(String name) {
            super(name);
        }

        public DoubleProperty build() {
            return new DoubleProperty(this.name, this.description, (Double)this.lowerLimit, (Double)this.upperLimit, (Double)this.defaultValue, this.uiOrder, this.isDefinedInXML);
        }
    }
}

