/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.properties.ValueParser;
import net.sourceforge.pmd.properties.modules.MethodPropertyModule;
import net.sourceforge.pmd.util.ClassUtil;
import org.apache.commons.lang3.StringUtils;

public final class ValueParserConstants {
    static final ValueParser<Method> METHOD_PARSER = new ValueParser<Method>(){

        @Override
        public Method valueOf(String value) throws IllegalArgumentException {
            return this.methodFrom(value, '#', ',');
        }

        Method methodFrom(String methodNameAndArgTypes, char classMethodDelimiter, char methodArgDelimiter) {
            int delimPos0 = -1;
            if (methodNameAndArgTypes == null) {
                return null;
            }
            delimPos0 = methodNameAndArgTypes.indexOf(classMethodDelimiter);
            if (delimPos0 < 0) {
                return null;
            }
            String className = methodNameAndArgTypes.substring(0, delimPos0);
            Class<?> type = ClassUtil.getTypeFor(className);
            if (type == null) {
                return null;
            }
            int delimPos1 = methodNameAndArgTypes.indexOf(MethodPropertyModule.METHOD_GROUP_DELIMITERS[0]);
            if (delimPos1 < 0) {
                String methodName = methodNameAndArgTypes.substring(delimPos0 + 1);
                return ClassUtil.methodFor(type, methodName, ClassUtil.EMPTY_CLASS_ARRAY);
            }
            String methodName = methodNameAndArgTypes.substring(delimPos0 + 1, delimPos1);
            if (StringUtils.isBlank((CharSequence)methodName)) {
                return null;
            }
            int delimPos2 = methodNameAndArgTypes.indexOf(MethodPropertyModule.METHOD_GROUP_DELIMITERS[1]);
            if (delimPos2 < 0) {
                return null;
            }
            String argTypesStr = methodNameAndArgTypes.substring(delimPos1 + 1, delimPos2);
            if (StringUtils.isBlank((CharSequence)argTypesStr)) {
                return ClassUtil.methodFor(type, methodName, ClassUtil.EMPTY_CLASS_ARRAY);
            }
            String[] argTypeNames = StringUtils.split((String)argTypesStr, (char)methodArgDelimiter);
            Class[] argTypes = new Class[argTypeNames.length];
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = this.typeFor(argTypeNames[i]);
            }
            return ClassUtil.methodFor(type, methodName, argTypes);
        }

        private Class<?> typeFor(String typeName) {
            if (typeName.endsWith("[]")) {
                String arrayTypeName = typeName.substring(0, typeName.length() - "[]".length());
                Class<?> type = this.typeFor(arrayTypeName);
                return Array.newInstance(type, 0).getClass();
            }
            Class<?> type = ClassUtil.getTypeFor(typeName);
            if (type != null) {
                return type;
            }
            try {
                return Class.forName(typeName);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
    };
    static final ValueParser<Character> CHARACTER_PARSER = new ValueParser<Character>(){

        @Override
        public Character valueOf(String value) {
            if (value == null || value.length() != 1) {
                throw new IllegalArgumentException("missing/ambiguous character value");
            }
            return Character.valueOf(value.charAt(0));
        }
    };
    static final ValueParser<String> STRING_PARSER = new ValueParser<String>(){

        @Override
        public String valueOf(String value) {
            return value;
        }
    };
    static final ValueParser<Integer> INTEGER_PARSER = new ValueParser<Integer>(){

        @Override
        public Integer valueOf(String value) {
            return Integer.valueOf(value);
        }
    };
    static final ValueParser<Boolean> BOOLEAN_PARSER = new ValueParser<Boolean>(){

        @Override
        public Boolean valueOf(String value) {
            return Boolean.valueOf(value);
        }
    };
    static final ValueParser<Float> FLOAT_PARSER = new ValueParser<Float>(){

        @Override
        public Float valueOf(String value) {
            return Float.valueOf(value);
        }
    };
    static final ValueParser<Long> LONG_PARSER = new ValueParser<Long>(){

        @Override
        public Long valueOf(String value) {
            return Long.valueOf(value);
        }
    };
    static final ValueParser<Double> DOUBLE_PARSER = new ValueParser<Double>(){

        @Override
        public Double valueOf(String value) {
            return Double.valueOf(value);
        }
    };
    static final ValueParser<File> FILE_PARSER = new ValueParser<File>(){

        @Override
        public File valueOf(String value) throws IllegalArgumentException {
            return new File(value);
        }
    };
    static final ValueParser<Pattern> REGEX_PARSER = new ValueParser<Pattern>(){

        @Override
        public Pattern valueOf(String value) throws IllegalArgumentException {
            return Pattern.compile(value);
        }
    };
    static final ValueParser<Class> CLASS_PARSER = new ValueParser<Class>(){

        @Override
        public Class valueOf(String value) throws IllegalArgumentException {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            Class<?> cls = ClassUtil.getTypeFor(value);
            if (cls != null) {
                return cls;
            }
            try {
                return Class.forName(value);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(value);
            }
        }
    };

    private ValueParserConstants() {
    }

    public static <U> ValueParser<List<U>> multi(final ValueParser<U> parser, final char delimiter) {
        return new ValueParser<List<U>>(){

            @Override
            public List<U> valueOf(String value) throws IllegalArgumentException {
                return ValueParserConstants.parsePrimitives(value, delimiter, parser);
            }
        };
    }

    static <U> List<U> parsePrimitives(String toParse, char delimiter, ValueParser<U> extractor) {
        String[] values = StringUtils.split((String)toParse, (char)delimiter);
        ArrayList<U> result = new ArrayList<U>();
        for (String s : values) {
            result.add(extractor.valueOf(s));
        }
        return result;
    }
}

