/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.modules;

import java.util.Collections;
import java.util.Map;
import net.sourceforge.pmd.util.CollectionUtil;

public class EnumeratedPropertyModule<E> {
    private final Map<String, E> choicesByLabel;
    private final Map<E, String> labelsByChoice;
    private final Class<E> valueType;

    public EnumeratedPropertyModule(Map<String, E> choicesByLabel, Class<E> valueType) {
        this.valueType = valueType;
        this.choicesByLabel = Collections.unmodifiableMap(choicesByLabel);
        this.labelsByChoice = Collections.unmodifiableMap(CollectionUtil.invertedMapFrom(choicesByLabel));
    }

    public Class<E> getValueType() {
        return this.valueType;
    }

    public Map<E, String> getLabelsByChoice() {
        return this.labelsByChoice;
    }

    public Map<String, E> getChoicesByLabel() {
        return this.choicesByLabel;
    }

    private String nonLegalValueMsgFor(E value) {
        return value + " is not a legal value";
    }

    public String errorFor(E value) {
        return this.labelsByChoice.containsKey(value) ? null : this.nonLegalValueMsgFor(value);
    }

    public E choiceFrom(String label) {
        E result = this.choicesByLabel.get(label);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException(label);
    }

    public void checkValue(E value) {
        if (!this.choicesByLabel.containsValue(value)) {
            throw new IllegalArgumentException("Invalid default value: no mapping to this value");
        }
    }
}

