/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;
import org.apache.commons.lang3.StringUtils;

public class YAHTMLRenderer
extends AbstractAccumulatingRenderer {
    public static final String NAME = "yahtml";
    public static final StringProperty OUTPUT_DIR = new StringProperty("outputDir", "Output directory.", null, 0.0f);
    private SortedMap<String, ReportNode> reportNodesByPackage = new TreeMap<String, ReportNode>();

    public YAHTMLRenderer() {
        super(NAME, "Yet Another HTML format.");
        this.definePropertyDescriptor(OUTPUT_DIR);
    }

    @Override
    public String defaultFileExtension() {
        return "html";
    }

    private void addViolation(RuleViolation violation) {
        String packageName = violation.getPackageName();
        int index = packageName.indexOf(46, 0);
        while (index > -1) {
            String currentPackage = packageName.substring(0, index);
            ReportNode reportNode = (ReportNode)this.reportNodesByPackage.get(currentPackage);
            if (reportNode == null) {
                reportNode = new ReportNode(currentPackage);
                this.reportNodesByPackage.put(currentPackage, reportNode);
            }
            reportNode.incrementViolations();
            int oldIndex = index;
            if ((index = packageName.indexOf(46, index + 1)) != -1 || oldIndex == packageName.length()) continue;
            index = packageName.length();
        }
        String fqClassName = packageName + "." + violation.getClassName();
        ReportNode classNode = (ReportNode)this.reportNodesByPackage.get(fqClassName);
        if (classNode == null) {
            classNode = new ReportNode(packageName, violation.getClassName());
            this.reportNodesByPackage.put(fqClassName, classNode);
        }
        classNode.addRuleViolation(violation);
        ReportNode rootNode = (ReportNode)this.reportNodesByPackage.get(" <root> ");
        if (rootNode == null) {
            rootNode = new ReportNode("Aggregate");
            this.reportNodesByPackage.put(" <root> ", rootNode);
        }
        rootNode.incrementViolations();
    }

    @Override
    public void end() throws IOException {
        String outputDir = this.getProperty(OUTPUT_DIR);
        Iterator<RuleViolation> violations = this.report.iterator();
        while (violations.hasNext()) {
            this.addViolation(violations.next());
        }
        this.renderIndex(outputDir);
        this.renderClasses(outputDir);
        this.writer.write("<h3 align=\"center\">The HTML files are located " + (outputDir == null ? "above the project directory" : "in '" + outputDir + '\'') + ".</h3>" + PMD.EOL);
    }

    private void renderIndex(String outputDir) throws IOException {
        try (PrintWriter out = new PrintWriter(new FileWriter(new File(outputDir, "index.html")));){
            out.println("<html>");
            out.println("    <head>");
            out.println("        <title>PMD</title>");
            out.println("    </head>");
            out.println("    <body>");
            out.println("    <h2>Package View</h2>");
            out.println("    <table border=\"1\" align=\"center\" cellspacing=\"0\" cellpadding=\"3\">");
            out.println("        <tr><th>Package</th><th>Class</th><th>#</th></tr>");
            for (ReportNode node : this.reportNodesByPackage.values()) {
                out.print("        <tr><td><b>");
                out.print(node.getPackageName());
                out.print("</b></td> <td>");
                if (node.hasViolations()) {
                    out.print("<a href=\"");
                    out.print(node.getClassName());
                    out.print(".html");
                    out.print("\">");
                    out.print(node.getClassName());
                    out.print("</a>");
                } else {
                    out.print(node.getClassName());
                }
                out.print("</td> <td>");
                out.print(node.getViolationCount());
                out.print("</td></tr>");
                out.println();
            }
            out.println("    </table>");
            out.println("    </body>");
            out.println("</html>");
        }
    }

    private void renderClasses(String outputDir) throws IOException {
        for (ReportNode node : this.reportNodesByPackage.values()) {
            if (!node.hasViolations()) continue;
            try (PrintWriter out = new PrintWriter(new FileWriter(new File(outputDir, node.getClassName() + ".html")));){
                out.println("<html>");
                out.println("    <head>");
                out.print("        <title>PMD - ");
                out.print(node.getClassName());
                out.println("</title>");
                out.println("    </head>");
                out.println("    <body>");
                out.println("        <h2>Class View</h2>");
                out.print("        <h3 align=\"center\">Class: ");
                out.print(node.getClassName());
                out.println("</h3>");
                out.println("        <table border=\"\" align=\"center\" cellspacing=\"0\" cellpadding=\"3\">");
                out.println("        <tr><th>Method</th><th>Violation</th></tr>");
                for (RuleViolation violation : node.getViolations()) {
                    out.print("        <tr><td>");
                    out.print(violation.getMethodName());
                    out.print("</td><td>");
                    out.print("<table border=\"0\">");
                    out.print(this.renderViolationRow("Rule:", violation.getRule().getName()));
                    out.print(this.renderViolationRow("Description:", violation.getDescription()));
                    if (StringUtils.isNotBlank((CharSequence)violation.getVariableName())) {
                        out.print(this.renderViolationRow("Variable:", violation.getVariableName()));
                    }
                    out.print(this.renderViolationRow("Line:", violation.getEndLine() > 0 ? violation.getBeginLine() + " and " + violation.getEndLine() : String.valueOf(violation.getBeginLine())));
                    out.print("</table>");
                    out.print("</td></tr>");
                    out.println();
                }
                out.println("        </table>");
                out.println("    </body>");
                out.println("</html>");
            }
        }
    }

    private String renderViolationRow(String name, String value) {
        StringBuilder row = new StringBuilder(40 + name.length() + value.length());
        row.append("<tr><td><b>").append(name).append("</b></td>").append("<td>").append(value).append("</td></tr>");
        return row.toString();
    }

    private static class ReportNode {
        private static final String ROOT_NODE_NAME = " <root> ";
        private final String packageName;
        private final String className;
        private int violationCount;
        private final List<RuleViolation> violations = new LinkedList<RuleViolation>();

        ReportNode(String packageName) {
            this.packageName = packageName;
            this.className = "-";
        }

        ReportNode(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }

        public void incrementViolations() {
            ++this.violationCount;
        }

        public void addRuleViolation(RuleViolation violation) {
            this.violations.add(violation);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public int getViolationCount() {
            return this.violationCount + this.violations.size();
        }

        public List<RuleViolation> getViolations() {
            return this.violations;
        }

        public boolean hasViolations() {
            return !this.violations.isEmpty();
        }

        public String toString() {
            return "ReportNode[packageName=" + this.packageName + ",className=" + this.className + ",violationCount=" + this.violationCount + ",violations=" + this.violations.size() + "]";
        }
    }
}

