/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.cache.internal.AnalysisCacheListener;
import net.sourceforge.pmd.cache.internal.NoopAnalysisCache;
import net.sourceforge.pmd.internal.LogMessages;
import net.sourceforge.pmd.internal.util.ClasspathClassLoader;
import net.sourceforge.pmd.internal.util.FileCollectionUtil;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.JvmLanguagePropertyBundle;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.lang.document.FileCollector;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.InternalApiBridge;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.reporting.ConfigurableFileNameRenderer;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ListenerInitializer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ReportStats;
import net.sourceforge.pmd.reporting.ReportStatsListener;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class PmdAnalysis
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PmdAnalysis.class);
    private final FileCollector collector;
    private final List<Renderer> renderers = new ArrayList<Renderer>();
    private final List<GlobalAnalysisListener> listeners = new ArrayList<GlobalAnalysisListener>();
    private final List<RuleSet> ruleSets = new ArrayList<RuleSet>();
    private final PMDConfiguration configuration;
    private final PmdReporter reporter;
    private final Map<Language, LanguagePropertyBundle> langProperties = new HashMap<Language, LanguagePropertyBundle>();
    private boolean closed;
    private final ConfigurableFileNameRenderer fileNameRenderer = new ConfigurableFileNameRenderer();

    private PmdAnalysis(PMDConfiguration config) {
        this.configuration = config;
        this.reporter = config.getReporter();
        this.collector = net.sourceforge.pmd.lang.document.InternalApiBridge.newCollector(config.getLanguageVersionDiscoverer(), this.reporter);
    }

    public static PmdAnalysis create(PMDConfiguration config) {
        PmdAnalysis pmd = new PmdAnalysis(config);
        FileCollectionUtil.collectFiles(config, pmd.files());
        if (config.getReportFormat() != null) {
            Renderer renderer = config.createRenderer(true);
            pmd.addRenderer(renderer);
        }
        if (!config.getRuleSetPaths().isEmpty()) {
            RuleSetLoader ruleSetLoader = pmd.newRuleSetLoader();
            List<RuleSet> ruleSets = InternalApiBridge.loadRuleSetsWithoutException(ruleSetLoader, config.getRuleSetPaths());
            pmd.addRuleSets(ruleSets);
        }
        for (Language language : config.getLanguageRegistry()) {
            LanguagePropertyBundle props = config.getLanguageProperties(language);
            assert (props.getLanguage().equals(language));
            pmd.langProperties.put(language, props);
            LanguageVersion forcedVersion = config.getForceLanguageVersion();
            if (forcedVersion != null && forcedVersion.getLanguage().equals(language)) {
                props.setLanguageVersion(forcedVersion.getVersion());
            }
            props.setProperty(LanguagePropertyBundle.SUPPRESS_MARKER, config.getSuppressMarker());
            if (!(props instanceof JvmLanguagePropertyBundle)) continue;
            ((JvmLanguagePropertyBundle)props).setClassLoader(config.getClassLoader());
        }
        for (Path path : config.getRelativizeRoots()) {
            pmd.fileNameRenderer.relativizeWith(path);
        }
        return pmd;
    }

    List<RuleSet> rulesets() {
        return this.ruleSets;
    }

    List<Renderer> renderers() {
        return this.renderers;
    }

    public FileCollector files() {
        return this.collector;
    }

    public RuleSetLoader newRuleSetLoader() {
        return RuleSetLoader.fromPmdConfig(this.configuration);
    }

    public void addRenderer(Renderer renderer) {
        AssertionUtil.requireParamNotNull("renderer", renderer);
        this.renderers.add(renderer);
    }

    public void addRenderers(Collection<Renderer> renderers) {
        renderers.forEach(this::addRenderer);
    }

    public void addListener(GlobalAnalysisListener listener) {
        AssertionUtil.requireParamNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void addListeners(Collection<? extends GlobalAnalysisListener> listeners) {
        listeners.forEach(this::addListener);
    }

    public void addRuleSet(RuleSet ruleSet) {
        AssertionUtil.requireParamNotNull("rule set", ruleSet);
        this.ruleSets.add(ruleSet);
    }

    public void addRuleSets(Collection<RuleSet> ruleSets) {
        ruleSets.forEach(this::addRuleSet);
    }

    public List<RuleSet> getRulesets() {
        return Collections.unmodifiableList(this.ruleSets);
    }

    public LanguagePropertyBundle getLanguageProperties(Language language) {
        this.configuration.checkLanguageIsRegistered(language);
        return this.langProperties.computeIfAbsent(language, Language::newPropertyBundle);
    }

    public ConfigurableFileNameRenderer fileNameRenderer() {
        return this.fileNameRenderer;
    }

    public void performAnalysis() {
        this.performAnalysisImpl(Collections.emptyList());
    }

    public Report performAnalysisAndCollectReport() {
        try (Report.GlobalReportBuilderListener reportBuilder = new Report.GlobalReportBuilderListener();){
            this.performAnalysisImpl(CollectionUtil.listOf(reportBuilder, new Report.GlobalReportBuilderListener[0]));
            Report report = reportBuilder.getResultImpl();
            return report;
        }
    }

    void performAnalysisImpl(List<? extends Report.GlobalReportBuilderListener> extraListeners) {
        try (FileCollector files = this.collector;){
            files.filterLanguages(this.getApplicableLanguages(false));
            this.performAnalysisImpl(extraListeners, files.getCollectedFiles());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performAnalysisImpl(List<? extends Report.GlobalReportBuilderListener> extraListeners, List<TextFile> textFiles) {
        GlobalAnalysisListener listener;
        RuleSets rulesets = new RuleSets(this.ruleSets);
        try {
            AnalysisCacheListener cacheListener = new AnalysisCacheListener(this.configuration.getAnalysisCache(), rulesets, this.configuration.getClassLoader(), textFiles);
            listener = GlobalAnalysisListener.tee(CollectionUtil.listOf(this.createComposedRendererListener(this.renderers), GlobalAnalysisListener.tee(this.listeners), GlobalAnalysisListener.tee(extraListeners), cacheListener));
            try (ListenerInitializer initializer = listener.initializer();){
                initializer.setNumberOfFilesToAnalyze(textFiles.size());
                initializer.setFileNameRenderer(this.fileNameRenderer());
            }
        }
        catch (Exception e) {
            this.reporter.errorEx("Exception while initializing analysis listeners", e);
            throw new RuntimeException("Exception while initializing analysis listeners", e);
        }
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.FILE_PROCESSING);){
            for (Rule rule : this.removeBrokenRules(rulesets)) {
                listener.onConfigError(new Report.ConfigurationError(rule, rule.dysfunctionReason()));
            }
            PmdAnalysis.encourageToUseIncrementalAnalysis(this.configuration);
            try (LanguageProcessorRegistry lpRegistry = LanguageProcessorRegistry.create(new LanguageRegistry(this.getApplicableLanguages(true)), this.langProperties, this.reporter);){
                LanguageProcessor.AnalysisTask analysisTask = net.sourceforge.pmd.lang.InternalApiBridge.createAnalysisTask(rulesets, textFiles, listener, this.configuration.getThreads(), this.configuration.getAnalysisCache(), this.reporter, lpRegistry);
                ArrayList<AutoCloseable> analyses = new ArrayList<AutoCloseable>();
                try {
                    for (Language lang : lpRegistry.getLanguages()) {
                        analyses.add(lpRegistry.getProcessor(lang).launchAnalysis(analysisTask));
                    }
                }
                finally {
                    Exception e = IOUtil.closeAll(analyses);
                    if (e != null) {
                        this.reporter.errorEx("Error while joining analysis", e);
                    }
                }
            }
            catch (LanguageProcessorRegistry.LanguageTerminationException e) {
                this.reporter.errorEx("Error while closing language processors", e);
            }
        }
        finally {
            try {
                listener.close();
            }
            catch (Exception e) {
                this.reporter.errorEx("Exception while closing analysis listeners", e);
                throw new RuntimeException("Exception while closing analysis listeners", e);
            }
        }
    }

    private GlobalAnalysisListener createComposedRendererListener(List<Renderer> renderers) throws Exception {
        if (renderers.isEmpty()) {
            return GlobalAnalysisListener.noop();
        }
        ArrayList<GlobalAnalysisListener> rendererListeners = new ArrayList<GlobalAnalysisListener>(renderers.size());
        for (Renderer renderer : renderers) {
            try {
                GlobalAnalysisListener listener = Objects.requireNonNull(renderer.newListener(), "Renderer should provide non-null listener");
                rendererListeners.add(listener);
            }
            catch (Exception ioe) {
                IOUtil.ensureClosed(rendererListeners, ioe);
                throw AssertionUtil.shouldNotReachHere("ensureClosed should have thrown", ioe);
            }
        }
        return GlobalAnalysisListener.tee(rendererListeners);
    }

    private Set<Language> getApplicableLanguages(boolean quiet) {
        boolean changed;
        HashSet<Language> languages = new HashSet<Language>();
        LanguageVersionDiscoverer discoverer = this.configuration.getLanguageVersionDiscoverer();
        for (RuleSet ruleSet : this.ruleSets) {
            for (Rule rule : ruleSet.getRules()) {
                LanguageVersion version;
                Language ruleLanguage = rule.getLanguage();
                Objects.requireNonNull(ruleLanguage, "Rule has no language " + rule);
                if (languages.contains(ruleLanguage) || !InternalApiBridge.ruleSetApplies(rule, version = discoverer.getDefaultLanguageVersion(ruleLanguage))) continue;
                this.configuration.checkLanguageIsRegistered(ruleLanguage);
                languages.add(ruleLanguage);
                if (quiet) continue;
                LOG.trace("Using {} version ''{}''", (Object)version.getLanguage().getName(), (Object)version.getTerseName());
            }
        }
        LanguageRegistry reg = this.configuration.getLanguageRegistry();
        do {
            changed = false;
            for (Language lang : new HashSet(languages)) {
                for (String depId : lang.getDependencies()) {
                    Language depLang = reg.getLanguageById(depId);
                    if (depLang == null) {
                        throw new IllegalStateException("Language " + lang.getId() + " has unsatisfied dependencies: " + depId + " is not found in " + reg);
                    }
                    changed |= languages.add(depLang);
                }
            }
        } while (changed);
        return languages;
    }

    private Set<Rule> removeBrokenRules(RuleSets ruleSets) {
        HashSet<Rule> brokenRules = new HashSet<Rule>();
        ruleSets.removeDysfunctionalRules(brokenRules);
        for (Rule rule : brokenRules) {
            this.reporter.warn("Removed misconfigured rule: {0} cause: {1}", rule.getName(), rule.dysfunctionReason());
        }
        return brokenRules;
    }

    public PmdReporter getReporter() {
        return this.reporter;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.collector.close();
        IOUtil.closeAll(this.listeners);
        if (this.configuration.getClassLoader() instanceof ClasspathClassLoader) {
            IOUtil.tryCloseClassLoader(this.configuration.getClassLoader());
        }
    }

    public ReportStats runAndReturnStats() {
        if (this.getRulesets().isEmpty()) {
            return ReportStats.empty();
        }
        ReportStatsListener listener = new ReportStatsListener();
        this.addListener(listener);
        try {
            this.performAnalysis();
        }
        catch (Exception e) {
            this.getReporter().errorEx("Exception during processing", e);
            ReportStats stats = (ReportStats)listener.getResult();
            this.printErrorDetected(1 + stats.getNumErrors());
            return stats;
        }
        ReportStats stats = (ReportStats)listener.getResult();
        if (stats.getNumErrors() > 0) {
            this.printErrorDetected(stats.getNumErrors());
        }
        return stats;
    }

    static void printErrorDetected(PmdReporter reporter, int errors) {
        String msg = LogMessages.errorDetectedMessage(errors, "PMD");
        reporter.info(StringUtil.quoteMessageFormat(msg), new Object[0]);
    }

    void printErrorDetected(int errors) {
        PmdAnalysis.printErrorDetected(this.getReporter(), errors);
    }

    private static void encourageToUseIncrementalAnalysis(PMDConfiguration configuration) {
        PmdReporter reporter = configuration.getReporter();
        if (!configuration.isIgnoreIncrementalAnalysis() && configuration.getAnalysisCache() instanceof NoopAnalysisCache && reporter.isLoggable(Level.WARN)) {
            String version = PMDVersion.isUnknown() || PMDVersion.isSnapshot() ? "latest" : "pmd-doc-" + PMDVersion.VERSION;
            reporter.warn("This analysis could be faster, please consider using Incremental Analysis: https://docs.pmd-code.org/{0}/pmd_userdocs_incremental_analysis.html", version);
        }
    }
}

