/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.Writer;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLRenderer
implements CPDReportRenderer {
    private static final String NAMESPACE_URI = "https://pmd-code.org/schema/cpd-report";
    private static final String NAMESPACE_LOCATION = "https://pmd.github.io/schema/cpd-report_1_0_0.xsd";
    private static final String SCHEMA_VERSION = "1.0.0";
    private String encoding;
    private final boolean newFormat;

    public XMLRenderer() {
        this(null, true);
    }

    public XMLRenderer(String encoding) {
        this(encoding, true);
    }

    XMLRenderer(String encoding, boolean newFormat) {
        this.setEncoding(encoding);
        this.newFormat = newFormat;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding != null ? encoding : System.getProperty("file.encoding");
    }

    public String getEncoding() {
        return this.encoding;
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            return parser.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private void dumpDocToWriter(Document doc, Writer writer) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("version", "1.0");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.encoding);
            transformer.setOutputProperty("indent", "yes");
            if (this.newFormat) {
                transformer.setOutputProperty("cdata-section-elements", "{https://pmd-code.org/schema/cpd-report}codefragment");
            } else {
                transformer.setOutputProperty("cdata-section-elements", "codefragment");
            }
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void render(CPDReport report, Writer writer) throws IOException {
        Document doc = this.createDocument();
        Element root = this.createElement(doc, "pmd-cpd");
        if (this.newFormat) {
            root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "https://pmd-code.org/schema/cpd-report https://pmd.github.io/schema/cpd-report_1_0_0.xsd");
            root.setAttributeNS(NAMESPACE_URI, "version", SCHEMA_VERSION);
            root.setAttributeNS(NAMESPACE_URI, "pmdVersion", PMDVersion.VERSION);
            root.setAttributeNS(NAMESPACE_URI, "timestamp", OffsetDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        Map<FileId, Integer> numberOfTokensPerFile = report.getNumberOfTokensPerFile();
        doc.appendChild(root);
        for (Map.Entry<FileId, Integer> pair : numberOfTokensPerFile.entrySet()) {
            Element fileElement = this.createElement(doc, "file");
            this.setAttribute(fileElement, "path", report.getDisplayName(pair.getKey()));
            this.setAttribute(fileElement, "totalNumberOfTokens", String.valueOf(pair.getValue()));
            root.appendChild(fileElement);
        }
        for (Match match : report.getMatches()) {
            Element dupElt = this.createDuplicationElement(doc, match);
            this.addFilesToDuplicationElement(doc, dupElt, match, report);
            this.addCodeSnippet(doc, dupElt, match, report);
            root.appendChild(dupElt);
        }
        if (this.newFormat) {
            for (Report.ProcessingError error : report.getProcessingErrors()) {
                Element errorElt = doc.createElementNS(NAMESPACE_URI, "error");
                errorElt.setAttributeNS(NAMESPACE_URI, "filename", report.getDisplayName(error.getFileId()));
                errorElt.setAttributeNS(NAMESPACE_URI, "msg", error.getMsg());
                errorElt.setTextContent(error.getDetail());
                root.appendChild(errorElt);
            }
        }
        this.dumpDocToWriter(doc, writer);
        writer.flush();
    }

    private void addFilesToDuplicationElement(Document doc, Element duplication, Match match, CPDReport report) {
        for (Mark mark : match) {
            Element file = this.createElement(doc, "file");
            FileLocation loc = mark.getLocation();
            this.setAttribute(file, "line", String.valueOf(loc.getStartLine()));
            String filenameXml10 = StringUtil.removedInvalidXml10Characters(report.getDisplayName(loc.getFileId()));
            this.setAttribute(file, "path", filenameXml10);
            this.setAttribute(file, "endline", String.valueOf(loc.getEndLine()));
            this.setAttribute(file, "column", String.valueOf(loc.getStartColumn()));
            this.setAttribute(file, "endcolumn", String.valueOf(loc.getEndColumn()));
            this.setAttribute(file, "begintoken", String.valueOf(mark.getBeginTokenIndex()));
            this.setAttribute(file, "endtoken", String.valueOf(mark.getEndTokenIndex()));
            duplication.appendChild(file);
        }
    }

    private void addCodeSnippet(Document doc, Element duplication, Match match, CPDReport report) {
        Chars codeSnippet = report.getSourceCodeSlice(match.getFirstMark());
        if (codeSnippet != null) {
            String platformSpecific = codeSnippet.toString().replace("\n", System.lineSeparator());
            Element codefragment = this.createElement(doc, "codefragment");
            codefragment.appendChild(doc.createCDATASection(StringUtil.removedInvalidXml10Characters(platformSpecific)));
            duplication.appendChild(codefragment);
        }
    }

    private Element createDuplicationElement(Document doc, Match match) {
        Element duplication = this.createElement(doc, "duplication");
        this.setAttribute(duplication, "lines", String.valueOf(match.getLineCount()));
        this.setAttribute(duplication, "tokens", String.valueOf(match.getTokenCount()));
        return duplication;
    }

    private Element createElement(Document doc, String name) {
        if (this.newFormat) {
            return doc.createElementNS(NAMESPACE_URI, name);
        }
        return doc.createElement(name);
    }

    private void setAttribute(Element element, String name, String value) {
        if (this.newFormat) {
            element.setAttributeNS(NAMESPACE_URI, name, value);
        } else {
            element.setAttribute(name, value);
        }
    }
}

