/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.properties.AbstractPropertySource;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LanguagePropertyBundle
extends AbstractPropertySource {
    public static final PropertyDescriptor<String> SUPPRESS_MARKER = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty("suppressMarker").desc("Marker to identify suppression comments. Eg a value of NOPMD will make `// NOPMD` a suppression comment in Java or JavaScript.")).defaultValue("NOPMD")).build();
    public static final String LANGUAGE_VERSION = "version";
    private final PropertyDescriptor<LanguageVersion> languageVersion;
    private final Language language;

    public LanguagePropertyBundle(@NonNull Language language) {
        this.language = language;
        this.definePropertyDescriptor(SUPPRESS_MARKER);
        this.languageVersion = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty(LANGUAGE_VERSION, CollectionUtil.associateBy(language.getVersions(), LanguageVersion::getVersion)).desc("Language version to use for this language. See the --use-version CLI switch as well.")).defaultValue(language.getDefaultVersion())).build();
        this.definePropertyDescriptor(this.languageVersion);
    }

    public void setLanguageVersion(String string) {
        this.setProperty(this.languageVersion, this.languageVersion.serializer().fromString(string));
    }

    @Override
    protected String getPropertySourceType() {
        return "Language";
    }

    @Override
    public String getName() {
        return this.language.getName();
    }

    public Language getLanguage() {
        return this.language;
    }

    public LanguageVersion getLanguageVersion() {
        return this.getProperty(this.languageVersion);
    }

    public String getSuppressMarker() {
        return this.getProperty(SUPPRESS_MARKER);
    }
}

