/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LexException
extends FileAnalysisException {
    private final int line;
    private final int column;

    public LexException(int line, int column, @Nullable FileId filename, String message, @Nullable Throwable cause) {
        super(message, cause);
        this.line = Math.max(line, 1);
        this.column = Math.max(column, 1);
        if (filename != null) {
            super.setFileId(filename);
        }
    }

    LexException(boolean eofSeen, String lexStateName, int errorLine, int errorColumn, String errorAfter, char curChar) {
        super(LexException.makeReason(eofSeen, lexStateName, errorAfter, curChar));
        this.line = Math.max(errorLine, 1);
        this.column = Math.max(errorColumn, 1);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    protected @NonNull FileLocation location() {
        return FileLocation.caret(this.getFileId(), this.line, this.column);
    }

    @Override
    protected String errorKind() {
        return "Lexical error";
    }

    @Override
    public LexException setFileId(FileId fileId) {
        super.setFileId(fileId);
        return this;
    }

    private static String makeReason(boolean eofseen, String lexStateName, String errorAfter, char curChar) {
        String message = eofseen ? "<EOF> " : "\"" + StringUtil.escapeJava(String.valueOf(curChar)) + "\" (" + curChar + "), ";
        message = message + "after : \"" + StringUtil.escapeJava(errorAfter) + "\" (in lexical state " + lexStateName + ")";
        return message;
    }
}

