/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.ast.internal.StreamImpl;
import net.sourceforge.pmd.util.DataMap;
import org.apache.commons.lang3.ArrayUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractNode<B extends AbstractNode<B, N>, N extends Node & GenericNode<N>>
implements GenericNode<N> {
    private static final Node[] EMPTY_ARRAY = new Node[0];
    private @Nullable DataMap<DataMap.DataKey<?, ?>> userData;
    private Node[] children = EMPTY_ARRAY;
    private B parent;
    private int childIndex;

    protected AbstractNode() {
    }

    @Override
    public final N getParent() {
        return (N)this.parent;
    }

    @Override
    public final int getIndexInParent() {
        return this.childIndex;
    }

    @Override
    public final N getChild(int index) {
        return (N)this.children[index];
    }

    @Override
    public final int getNumChildren() {
        return this.children.length;
    }

    protected void setParent(B parent) {
        this.parent = parent;
    }

    private B asSelf(Node n) {
        return (B)((AbstractNode)n);
    }

    protected void addChild(B child, int index) {
        assert (index >= 0) : "Invalid index " + index;
        assert (index >= this.children.length || this.children[index] == null) : "There is already a child at index " + index;
        if (index >= this.children.length) {
            Node[] newChildren = new Node[index + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.setChild(child, index);
    }

    protected void setChild(B child, int index) {
        assert (index >= 0 && index < this.children.length) : "Invalid index " + index + " for length " + this.children.length;
        this.children[index] = child;
        ((AbstractNode)child).setChildIndex(index);
        ((AbstractNode)child).setParent(this.asSelf(this));
    }

    protected void insertChild(B child, int index) {
        assert (index >= 0 && index <= this.children.length) : "Invalid index for insertion into array of length " + this.children.length + ": " + index;
        Node[] newChildren = new Node[this.children.length + 1];
        if (index != 0) {
            System.arraycopy(this.children, 0, newChildren, 0, index);
        }
        if (index != this.children.length) {
            System.arraycopy(this.children, index, newChildren, index + 1, this.children.length - index);
        }
        newChildren[index] = child;
        ((AbstractNode)child).setParent(this.asSelf(this));
        for (int i = index; i < newChildren.length; ++i) {
            ((AbstractNode)this.asSelf(newChildren[i])).setChildIndex(i);
        }
        this.children = newChildren;
    }

    protected void remove() {
        if (this.parent != null) {
            ((AbstractNode)this.parent).removeChildAtIndex(this.getIndexInParent());
            this.setParent(null);
        }
    }

    protected void removeChildAtIndex(int childIndex) {
        if (0 <= childIndex && childIndex < this.getNumChildren()) {
            this.children = (Node[])ArrayUtils.remove((Object[])this.children, (int)childIndex);
            for (int i = childIndex; i < this.getNumChildren(); ++i) {
                ((AbstractNode)this.asSelf((Node)this.getChild(i))).setChildIndex(i);
            }
        }
    }

    void setChildIndex(int index) {
        this.childIndex = index;
    }

    @Override
    public DataMap<DataMap.DataKey<?, ?>> getUserMap() {
        if (this.userData == null) {
            this.userData = DataMap.newDataMap();
        }
        return this.userData;
    }

    public String toString() {
        return this.getXPathNodeName();
    }

    @Override
    public final NodeStream<N> children() {
        return StreamImpl.childrenArray(this, this.children);
    }

    @Override
    public final <R extends Node> @Nullable R firstChild(Class<? extends R> rClass) {
        for (Node child : this.children) {
            if (!rClass.isInstance(child)) continue;
            return (R)child;
        }
        return null;
    }
}

