/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.Optional;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NodeFindingUtil {
    private NodeFindingUtil() {
    }

    public static Optional<Node> findNodeAt(Node root, int offset) {
        return Optional.ofNullable(NodeFindingUtil.findNodeImpl(root, offset));
    }

    private static @Nullable Node findNodeImpl(Node subject, int offset) {
        Node deepestNode = subject;
        if (!deepestNode.getTextRegion().contains(offset)) {
            return null;
        }
        Node child;
        while ((child = NodeFindingUtil.binarySearchInChildren(deepestNode, offset)) != null) {
            deepestNode = child;
        }
        return deepestNode;
    }

    private static Node binarySearchInChildren(Node parent, int offset) {
        int low = 0;
        int high = parent.getNumChildren() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            Node child = parent.getChild(mid);
            TextRegion childRegion = child.getTextRegion();
            int cmp = Integer.compare(childRegion.getStartOffset(), offset);
            if (cmp < 0) {
                low = mid + 1;
                if (childRegion.getEndOffset() <= offset) continue;
                return child;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return child;
        }
        return null;
    }

    public static Optional<Node> findNodeCovering(Node root, TextRegion range, boolean exact) {
        return NodeFindingUtil.findNodeAt(root, range.getStartOffset()).map(innermost -> {
            for (Node node : innermost.ancestorsOrSelf()) {
                TextRegion parentRange = node.getTextRegion();
                if (!exact && parentRange.contains(range)) {
                    return node;
                }
                if (exact && parentRange.equals(range)) {
                    return node;
                }
                if (!exact || !parentRange.contains(range)) continue;
                return null;
            }
            return null;
        });
    }
}

