/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import org.checkerframework.checker.nullness.qual.NonNull;

public final class TextPos2d
implements Comparable<TextPos2d> {
    private final int line;
    private final int column;

    private TextPos2d(int line, int column) {
        this.line = line;
        this.column = column;
        assert (line > 0 && column > 0) : "Invalid position " + this.toTupleString();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public static TextPos2d pos2d(int line, int column) {
        return new TextPos2d(line, column);
    }

    @Override
    public int compareTo(@NonNull TextPos2d that) {
        int cmp = Integer.compare(this.getLine(), that.getLine());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.getColumn(), that.getColumn());
    }

    public String toTupleString() {
        return "(line=" + this.line + ", column=" + this.column + ")";
    }

    public String toDisplayStringInEnglish() {
        return "line " + this.line + ", column " + this.column;
    }

    public String toDisplayStringWithColon() {
        return this.line + ":" + this.column;
    }

    public String toString() {
        return "!debug only! Pos2d(line=" + this.line + ", column=" + this.column + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextPos2d)) {
            return false;
        }
        TextPos2d that = (TextPos2d)o;
        return this.line == that.getLine() && this.column == that.getColumn();
    }

    public int hashCode() {
        return this.line * 31 + this.column;
    }
}

