/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.cache.internal.AnalysisCache;
import net.sourceforge.pmd.internal.SystemProps;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.ast.SemanticException;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PmdRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PmdRunnable.class);
    private final TextFile textFile;
    private final LanguageProcessor.AnalysisTask task;

    PmdRunnable(TextFile textFile, LanguageProcessor.AnalysisTask task) {
        this.textFile = textFile;
        this.task = task;
    }

    protected abstract RuleSets getRulesets();

    @Override
    public void run() throws FileAnalysisException {
        block33: {
            TimeTracker.initThread();
            try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.FILE_PROCESSING);
                 FileAnalysisListener listener = this.task.getListener().startFileAnalysis(this.textFile);){
                RuleSets ruleSets = this.getRulesets();
                if (ruleSets.applies(this.textFile)) {
                    AnalysisCache analysisCache = this.task.getAnalysisCache();
                    try (TextDocument textDocument = TextDocument.create(this.textFile);
                         FileAnalysisListener cacheListener = analysisCache.startFileAnalysis(textDocument);){
                        FileAnalysisListener completeListener = FileAnalysisListener.tee(CollectionUtil.listOf(listener, cacheListener));
                        if (analysisCache.isUpToDate(textDocument)) {
                            LOG.trace("Skipping file (lang: {}) because it was found in the cache: {}", (Object)this.textFile.getLanguageVersion(), (Object)this.textFile.getFileId().getAbsolutePath());
                            this.reportCachedRuleViolations(listener, textDocument);
                        } else {
                            LOG.trace("Processing file (lang: {}): {}", (Object)this.textFile.getLanguageVersion(), (Object)this.textFile.getFileId().getAbsolutePath());
                            try {
                                this.processSource(completeListener, textDocument, ruleSets);
                            }
                            catch (AssertionError | Exception | StackOverflowError e) {
                                if (e instanceof Error && !SystemProps.isErrorRecoveryMode()) {
                                    throw e;
                                }
                                completeListener.onError(new Report.ProcessingError((Throwable)e, this.textFile.getFileId()));
                            }
                        }
                        break block33;
                    }
                }
                LOG.trace("Skipping file (lang: {}) because no rule applies: {}", (Object)this.textFile.getLanguageVersion(), (Object)this.textFile.getFileId());
            }
            catch (FileAnalysisException e) {
                throw e;
            }
            catch (Exception e) {
                throw FileAnalysisException.wrap(this.textFile.getFileId(), "An unknown exception occurred", e);
            }
        }
        TimeTracker.finishThread();
    }

    private void reportCachedRuleViolations(FileAnalysisListener ctx, TextDocument file) {
        for (RuleViolation rv : this.task.getAnalysisCache().getCachedViolations(file)) {
            ctx.onRuleViolation(rv);
        }
    }

    private RootNode parse(Parser parser, Parser.ParserTask task) {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.PARSER);){
            RootNode rootNode = parser.parse(task);
            return rootNode;
        }
    }

    private void processSource(FileAnalysisListener listener, TextDocument textDocument, RuleSets ruleSets) throws FileAnalysisException {
        SemanticErrorReporter reporter = SemanticErrorReporter.reportToLogger(this.task.getMessageReporter());
        LanguageProcessor processor = this.task.getLpRegistry().getProcessor(textDocument.getLanguageVersion().getLanguage());
        Parser.ParserTask parserTask = new Parser.ParserTask(textDocument, reporter, this.task.getLpRegistry());
        LanguageVersionHandler handler = processor.services();
        Parser parser = handler.getParser();
        RootNode rootNode = this.parse(parser, parserTask);
        SemanticException semanticError = reporter.getFirstError();
        if (semanticError != null) {
            throw semanticError;
        }
        ruleSets.apply(rootNode, listener);
    }
}

