/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import java.util.function.Function;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.PmdCapableLanguage;
import net.sourceforge.pmd.lang.impl.BatchLanguageProcessor;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SimpleLanguageModuleBase
extends LanguageModuleBase
implements PmdCapableLanguage,
CpdCapableLanguage {
    private final Function<LanguagePropertyBundle, LanguageVersionHandler> handler;

    protected SimpleLanguageModuleBase(LanguageModuleBase.LanguageMetadata metadata, LanguageVersionHandler handler) {
        this(metadata, (LanguagePropertyBundle p) -> handler);
    }

    public SimpleLanguageModuleBase(LanguageModuleBase.LanguageMetadata metadata, Function<LanguagePropertyBundle, LanguageVersionHandler> makeHandler) {
        super(metadata);
        this.handler = makeHandler;
    }

    @Override
    public LanguageProcessor createProcessor(LanguagePropertyBundle bundle) {
        final LanguageVersionHandler services = this.handler.apply(bundle);
        return new BatchLanguageProcessor<LanguagePropertyBundle>(bundle){

            @Override
            public @NonNull LanguageVersionHandler services() {
                return services;
            }
        };
    }
}

