/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.properties.AbstractPropertySource;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.reporting.InternalApiBridge;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractRule
extends AbstractPropertySource
implements Rule {
    private Language language;
    private LanguageVersion minimumLanguageVersion;
    private LanguageVersion maximumLanguageVersion;
    private boolean deprecated;
    private String name = this.getClass().getName();
    private String since;
    private String ruleClass = this.getClass().getName();
    private String ruleSetName;
    private String message;
    private String description;
    private List<String> examples = new ArrayList<String>();
    private String externalInfoUrl;
    private RulePriority priority = RulePriority.LOW;
    private Set<String> ruleChainVisits = new LinkedHashSet<String>();
    private Set<Class<? extends Node>> classRuleChainVisits = new LinkedHashSet<Class<? extends Node>>();
    private RuleTargetSelector myStrategy;

    public AbstractRule() {
        this.definePropertyDescriptor(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR);
        this.definePropertyDescriptor(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR);
    }

    @Override
    protected String getPropertySourceType() {
        return "rule";
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(Language language) {
        if (this.language != null && !this.language.equals(language)) {
            throw new UnsupportedOperationException("The Language for Rule class " + this.getClass().getName() + " is immutable and cannot be changed.");
        }
        this.language = language;
    }

    @Override
    public LanguageVersion getMinimumLanguageVersion() {
        return this.minimumLanguageVersion;
    }

    @Override
    public void setMinimumLanguageVersion(LanguageVersion minimumLanguageVersion) {
        if (minimumLanguageVersion != null && !minimumLanguageVersion.getLanguage().equals(this.getLanguage())) {
            throw new IllegalArgumentException("Version " + minimumLanguageVersion + " does not belong to language " + this.getLanguage());
        }
        this.minimumLanguageVersion = minimumLanguageVersion;
    }

    @Override
    public LanguageVersion getMaximumLanguageVersion() {
        return this.maximumLanguageVersion;
    }

    @Override
    public void setMaximumLanguageVersion(LanguageVersion maximumLanguageVersion) {
        if (maximumLanguageVersion != null && !maximumLanguageVersion.getLanguage().equals(this.getLanguage())) {
            throw new IllegalArgumentException("Version " + maximumLanguageVersion + " does not belong to language " + this.getLanguage());
        }
        this.maximumLanguageVersion = maximumLanguageVersion;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public void setSince(String since) {
        this.since = since;
    }

    @Override
    public String getRuleClass() {
        return this.ruleClass;
    }

    @Override
    public void setRuleClass(String ruleClass) {
        this.ruleClass = ruleClass;
    }

    @Override
    public String getRuleSetName() {
        return this.ruleSetName;
    }

    @Override
    public void setRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public void addExample(String example) {
        this.examples.add(example);
    }

    @Override
    public String getExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    @Override
    public void setExternalInfoUrl(String externalInfoUrl) {
        this.externalInfoUrl = externalInfoUrl;
    }

    @Override
    public RulePriority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(RulePriority priority) {
        this.priority = priority;
    }

    private Set<Class<? extends Node>> getClassRuleChainVisits() {
        if (this.classRuleChainVisits.isEmpty() && this.ruleChainVisits.isEmpty()) {
            return Collections.singleton(RootNode.class);
        }
        return this.classRuleChainVisits;
    }

    @Override
    public final RuleTargetSelector getTargetSelector() {
        if (this.myStrategy == null) {
            this.myStrategy = this.buildTargetSelector();
        }
        return this.myStrategy;
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        Set<Class<? extends Node>> crvs = this.getClassRuleChainVisits();
        return crvs.isEmpty() ? RuleTargetSelector.forRootOnly() : RuleTargetSelector.forTypes(crvs);
    }

    @Override
    public void start(RuleContext ctx) {
    }

    @Override
    public void end(RuleContext ctx) {
    }

    protected final RuleContext asCtx(Object ctx) {
        if (ctx instanceof RuleContext) {
            assert (this.isThisRule(InternalApiBridge.getRule((RuleContext)ctx))) : "not an appropriate rule context!";
            return (RuleContext)ctx;
        }
        throw new ClassCastException("Unexpected context object! " + ctx);
    }

    private boolean isThisRule(Rule rule) {
        return rule == this || rule instanceof RuleReference && this.isThisRule(((RuleReference)rule).getRule());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRule that = (AbstractRule)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals((Object)this.getPriority(), (Object)that.getPriority()) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getPriority(), super.hashCode()});
    }

    @Override
    public Rule deepCopy() {
        Rule result;
        try {
            Constructor<?> declaredConstructor = this.getClass().getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            result = (Rule)declaredConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
            throw new RuntimeException(ignored);
        }
        Rule rule = result;
        rule.setName(this.getName());
        rule.setLanguage(this.getLanguage());
        rule.setMinimumLanguageVersion(this.getMinimumLanguageVersion());
        rule.setMaximumLanguageVersion(this.getMaximumLanguageVersion());
        rule.setSince(this.getSince());
        rule.setMessage(this.getMessage());
        rule.setRuleSetName(this.getRuleSetName());
        rule.setExternalInfoUrl(this.getExternalInfoUrl());
        rule.setDescription(this.getDescription());
        for (String string : this.getExamples()) {
            rule.addExample(string);
        }
        rule.setPriority(this.getPriority());
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            if (rule.getPropertyDescriptor(propertyDescriptor.name()) == null) {
                rule.definePropertyDescriptor(propertyDescriptor);
            }
            if (!this.isPropertyOverridden(propertyDescriptor)) continue;
            rule.setProperty(propertyDescriptor, this.getProperty(propertyDescriptor));
        }
        return rule;
    }
}

