/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DomainConversion {
    private DomainConversion() {
    }

    public static SchemaType buildType(Type type) {
        switch (type.getTypeName()) {
            case "java.lang.Integer": 
            case "java.lang.Long": {
                return BuiltInAtomicType.INTEGER;
            }
            case "java.lang.Double": 
            case "java.lang.Float": {
                return BuiltInAtomicType.DOUBLE;
            }
            case "java.lang.String": 
            case "java.lang.Character": 
            case "java.lang.Class": 
            case "java.util.regex.Pattern": {
                return BuiltInAtomicType.STRING;
            }
        }
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public static @NonNull AtomicSequence convert(Object obj) {
        if (obj instanceof Collection) {
            return DomainConversion.getSequenceRepresentation((Collection)obj);
        }
        return DomainConversion.getAtomicRepresentation(obj);
    }

    public static SequenceType typeOf(Object obj) {
        if (obj instanceof Collection) {
            if (((Collection)obj).isEmpty()) {
                return SequenceType.EMPTY_SEQUENCE;
            }
            return SequenceType.NON_EMPTY_SEQUENCE;
        }
        if (obj instanceof String) {
            return SequenceType.SINGLE_STRING;
        }
        if (obj instanceof Boolean) {
            return SequenceType.SINGLE_BOOLEAN;
        }
        if (obj instanceof Integer) {
            return SequenceType.SINGLE_INTEGER;
        }
        if (obj instanceof Float) {
            return SequenceType.SINGLE_FLOAT;
        }
        if (obj instanceof Long) {
            return SequenceType.SINGLE_INTEGER;
        }
        if (obj instanceof Double) {
            return SequenceType.SINGLE_DOUBLE;
        }
        if (obj instanceof Number) {
            return SequenceType.SINGLE_NUMERIC;
        }
        if (obj instanceof Enum) {
            return SequenceType.SINGLE_STRING;
        }
        if (obj instanceof Character) {
            return SequenceType.SINGLE_STRING;
        }
        if (obj instanceof Pattern) {
            return SequenceType.SINGLE_STRING;
        }
        return SequenceType.SINGLE_ITEM;
    }

    public static AtomicSequence getSequenceRepresentation(Collection<?> list) {
        if (list == null || list.isEmpty()) {
            return EmptyAtomicSequence.getInstance();
        }
        ArrayList<AtomicValue> vs = new ArrayList<AtomicValue>(list.size());
        DomainConversion.flattenInto(list, vs);
        return new AtomicArray(vs);
    }

    private static void flattenInto(Collection<?> list, List<AtomicValue> values) {
        for (Object o : list) {
            if (o instanceof Collection) {
                DomainConversion.flattenInto((Collection)o, values);
                continue;
            }
            values.add(DomainConversion.getAtomicRepresentation(o));
        }
    }

    public static @NonNull AtomicValue getAtomicRepresentation(Object value) {
        if (value == null) {
            return StringValue.ZERO_LENGTH_UNTYPED;
        }
        if (value instanceof String) {
            return new StringValue((String)value);
        }
        if (value instanceof Boolean) {
            return BooleanValue.get((boolean)((Boolean)value));
        }
        if (value instanceof Integer) {
            return Int64Value.makeIntegerValue((long)((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new BigIntegerValue(((Long)value).longValue());
        }
        if (value instanceof Double) {
            return new DoubleValue(((Double)value).doubleValue());
        }
        if (value instanceof Character) {
            return new StringValue(value.toString());
        }
        if (value instanceof Float) {
            return new FloatValue(((Float)value).floatValue());
        }
        if (value instanceof Pattern || value instanceof Enum) {
            return new StringValue(String.valueOf(value));
        }
        throw new RuntimeException("Unable to create ValueRepresentation for value of type: " + value.getClass());
    }
}

