/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.reporting.RuleViolation;

public class TextPadRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "textpad";

    public TextPadRenderer() {
        super(NAME, "TextPad integration.");
    }

    @Override
    public String defaultFileExtension() {
        return "txt";
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        StringBuilder buf = new StringBuilder();
        while (violations.hasNext()) {
            RuleViolation rv = violations.next();
            buf.setLength(0);
            buf.append(this.determineFileName(rv.getFileId())).append("(");
            buf.append(rv.getBeginLine()).append(",  ");
            buf.append(rv.getRule().getName()).append("):  ");
            buf.append(rv.getDescription());
            this.writer.println(buf);
        }
    }
}

