/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.reporting.FileNameRenderer;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConfigurableFileNameRenderer
implements FileNameRenderer {
    private final List<Path> relativizeRootPaths = new ArrayList<Path>();
    private static final Pattern PATH_SEP_PAT = Pattern.compile("[/\\\\]");

    public void relativizeWith(Path path) {
        this.relativizeRootPaths.add(Objects.requireNonNull(path));
        this.relativizeRootPaths.sort(Comparator.naturalOrder());
    }

    @Override
    public String getDisplayName(@NonNull FileId fileId) {
        String localDisplayName = this.getLocalDisplayName(fileId);
        FileId parent = fileId.getParentFsPath();
        if (parent != null) {
            return this.getDisplayName(parent) + "!" + localDisplayName;
        }
        return localDisplayName;
    }

    private String getLocalDisplayName(FileId file) {
        if (!this.relativizeRootPaths.isEmpty()) {
            return ConfigurableFileNameRenderer.getDisplayName(file, this.relativizeRootPaths);
        }
        return file.getOriginalPath();
    }

    private static int countSegments(String best) {
        return StringUtils.countMatches((CharSequence)best, (char)File.separatorChar);
    }

    private static String relativizePath(Path base, String other) {
        int prefixLength;
        assert (base.isAbsolute()) : "Expected an absolute path: " + base;
        int windowsDriveEndIndex = other.indexOf(58);
        if (windowsDriveEndIndex != -1 && windowsDriveEndIndex < other.length() - 1) {
            other = other.substring(windowsDriveEndIndex + 1);
        }
        String[] otherSegments = PATH_SEP_PAT.split(other);
        int maxi = Math.min(base.getNameCount(), otherSegments.length - 1);
        for (prefixLength = 0; prefixLength < maxi && base.getName(prefixLength).toString().equals(otherSegments[prefixLength + 1]); ++prefixLength) {
        }
        if (prefixLength == 0) {
            return other;
        }
        ArrayList<String> relative = new ArrayList<String>();
        for (int i = prefixLength; i < base.getNameCount(); ++i) {
            relative.add("..");
        }
        relative.addAll(Arrays.asList(otherSegments).subList(prefixLength + 1, otherSegments.length));
        return String.join((CharSequence)File.separator, relative);
    }

    private static boolean isFileSystemRoot(Path root) {
        return root.isAbsolute() && root.getNameCount() == 0;
    }

    static String getDisplayName(FileId file, List<Path> relativizeRoots) {
        String fileAbsPath;
        String best = fileAbsPath = file.getAbsolutePath();
        for (Path root : relativizeRoots) {
            if (ConfigurableFileNameRenderer.isFileSystemRoot(root)) {
                best = fileAbsPath;
                continue;
            }
            String relative = ConfigurableFileNameRenderer.relativizePath(root.toAbsolutePath(), fileAbsPath);
            if (ConfigurableFileNameRenderer.countSegments(relative) >= ConfigurableFileNameRenderer.countSegments(best)) continue;
            best = relative;
        }
        return best;
    }
}

