/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ReportStats;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.BaseResultProducingCloseable;

public final class ReportStatsListener
extends BaseResultProducingCloseable<ReportStats>
implements GlobalAnalysisListener {
    private final AtomicInteger numErrors = new AtomicInteger(0);
    private final AtomicInteger numViolations = new AtomicInteger(0);

    @Override
    public FileAnalysisListener startFileAnalysis(TextFile file) {
        return new FileAnalysisListener(){
            private int numErrors = 0;
            private int numViolations = 0;

            @Override
            public void onRuleViolation(RuleViolation violation) {
                ++this.numViolations;
            }

            @Override
            public void onError(Report.ProcessingError error) {
                ++this.numErrors;
            }

            @Override
            public void close() {
                if (this.numErrors > 0) {
                    ReportStatsListener.this.numErrors.addAndGet(this.numErrors);
                }
                if (this.numViolations > 0) {
                    ReportStatsListener.this.numViolations.addAndGet(this.numViolations);
                }
            }
        };
    }

    @Override
    protected ReportStats getResultImpl() {
        return new ReportStats(this.numErrors.get(), this.numViolations.get());
    }
}

